import React from "react";

const AddressNotFoundSvg = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="251"
      height="176"
      fill="none"
    >
      <g clipPath="url(#a)">
        <path
          fill="#EAEFF8"
          fillRule="evenodd"
          d="M125.501 171.175c29.193 0 56.056.436 77.376 1.167 52.174-29.766 34.108-87.786 15.374-120.604-26.072-45.673-87.677-62.09-113.159-25.647-34.587 49.465-67.953 32.203-85.97 69.77-18.015 37.566 9.346 73.579 29.001 76.482 21.32-.732 48.184-1.166 77.376-1.166l.002-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#D2DFEE"
          fillRule="evenodd"
          d="M125.501 171.176c69.312 0 125.5 2.456 125.5 5.486s-56.188 5.486-125.5 5.486C56.188 182.148 0 179.693 0 176.663c0-3.03 56.188-5.486 125.501-5.486v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M165.971 19.737c31.344 6.97 51.291 35.741 53.245 49.632.802 5.7-.684-7.639-16.674-19.785-14.289-10.855-25.415-12.866-42.415-14.177-12.014-.927-24.596-2.4-23.702-9.553.706-5.648 9.31-10.616 29.546-6.117Z"
          clipRule="evenodd"
        />
        <path
          fill="#D2DFEE"
          fillRule="evenodd"
          d="M44.657 158.536c-1.43-1.788-3.444-3.266-4.036-5.476-.697-2.611.838-5.358.457-8.033-.478-3.366-3.727-5.548-5.49-8.457-1.726-2.849-.917-3.806-1.074-7.133-.236-5.011-4.354-11.337-9.84-9.64-5.57 1.725-4.662 6.893-3.681 10.782.699 2.769.242 3.168-.437 5.943-.82 3.351-3.463 6.589-2.359 9.857.683 2.021 2.669 3.385 3.388 5.394.814 2.277-.172 4.745-.55 7.133-.8 5.026.347 9.207 4.005 13.358.393.373.802.719 1.226 1.041a930.28 930.28 0 0 1 17.214-.794l.046-.049c3.348-3.649 4.348-9.909 1.131-13.926Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M27.202 124.321a.44.44 0 0 0-.823.314c.435 1.136.8 2.325 1.114 3.563a7.77 7.77 0 0 0-.391-.332 10.215 10.215 0 0 0-2.035-1.257.439.439 0 1 0-.375.794 9.28 9.28 0 0 1 1.86 1.148c.515.412.962.873 1.34 1.385.563 2.681.93 5.563 1.262 8.604a15.574 15.574 0 0 0-1.633-2.128c-1.006-1.091-2.118-1.938-3.339-2.542a.438.438 0 1 0-.39.786c1.118.552 2.145 1.337 3.081 2.351.93 1.009 1.766 2.243 2.51 3.701l.084.826a353.985 353.985 0 0 0 .614 5.624c.238 1.983.514 4.009.865 6.067-.951-1.466-1.975-2.762-3.07-3.887-1.607-1.651-3.369-2.937-5.286-3.858a.44.44 0 1 0-.38.792c1.822.876 3.5 2.103 5.034 3.678 1.529 1.57 2.916 3.491 4.158 5.757a71.784 71.784 0 0 0 2.147 8.317v.002l.004.01c.45 1.38.953 2.765 1.521 4.155a25.764 25.764 0 0 0-4.242-2.961 25.665 25.665 0 0 0-6.716-2.566.44.44 0 1 0-.198.857 24.741 24.741 0 0 1 6.488 2.477 25.322 25.322 0 0 1 5.52 4.17c.39.866.806 1.732 1.251 2.599l.969-.042a58.62 58.62 0 0 1-3.74-8.922c-.166-2.143.089-4.286.762-6.427.684-2.172 1.8-4.346 3.348-6.526a.44.44 0 1 0-.716-.507c-1.6 2.252-2.756 4.509-3.468 6.768a18.37 18.37 0 0 0-.783 3.85c-1.32-4.759-2.052-9.412-2.587-13.853.517-1.883 1.094-3.474 1.73-4.777.634-1.297 1.323-2.296 2.066-2.996a.439.439 0 1 0-.604-.638c-.823.777-1.576 1.861-2.255 3.252-.423.864-.82 1.852-1.191 2.962-.13-1.173-.249-2.33-.366-3.467l-.092-.885a.353.353 0 0 0-.005-.049c-.627-6.034-1.257-11.524-3.046-16.189h.003Z"
          clipRule="evenodd"
        />
        <path
          fill="#C5DEF8"
          fillRule="evenodd"
          d="M29.921 160.892c-1.528-.822-3.37-1.256-4.437-2.622-1.261-1.611-1.007-3.979-2.065-5.73-1.332-2.204-4.243-2.763-6.334-4.267-2.049-1.474-1.769-2.382-2.866-4.652-1.653-3.42-6.4-6.609-9.717-3.805-3.368 2.849-1.2 6.179.637 8.598 1.308 1.724 1.109 2.135 1.46 4.268.423 2.577-.457 5.615 1.282 7.564 1.076 1.206 2.864 1.569 3.96 2.757 1.243 1.344 1.29 3.355 1.734 5.131.59 2.357 1.62 4.251 3.246 5.782 4.39-.331 9.551-.641 15.375-.924a8.614 8.614 0 0 0 1.071-2.067c1.25-3.532.087-8.188-3.346-10.034v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M7.607 142.221a.332.332 0 1 0-.48.461c.64.663 1.248 1.384 1.835 2.152a8.208 8.208 0 0 0-.372-.116 7.723 7.723 0 0 0-1.79-.272.332.332 0 0 0-.026.665 7.055 7.055 0 0 1 1.637.248c.48.136.93.325 1.345.568 1.188 1.702 2.3 3.601 3.433 5.621-.59-.4-1.18-.733-1.77-.999-1.024-.463-2.051-.725-3.08-.784a.332.332 0 1 0-.04.663c.944.055 1.892.298 2.845.728.947.428 1.896 1.04 2.846 1.836l.304.548c.669 1.207 1.354 2.445 2.075 3.699l.021.037a93.772 93.772 0 0 0 2.403 3.971 19.202 19.202 0 0 0-3.292-1.8c-1.609-.674-3.218-1.05-4.827-1.124a.332.332 0 1 0-.031.664c1.53.071 3.063.429 4.599 1.073 1.531.642 3.067 1.569 4.605 2.781a54.728 54.728 0 0 0 3.965 5.158l.005.007a45.75 45.75 0 0 0 2.293 2.444 19.362 19.362 0 0 0-3.833-.806 19.453 19.453 0 0 0-5.44.197.332.332 0 0 0-.271.385c.031.18.204.301.386.27a18.746 18.746 0 0 1 5.255-.194c1.71.181 3.406.606 5.083 1.273.578.533 1.18 1.058 1.805 1.574l.992-.051a44.444 44.444 0 0 1-5.745-5.506 12.798 12.798 0 0 1-1.375-4.702c-.169-1.716-.038-3.561.394-5.536a.333.333 0 0 0-.65-.142c-.446 2.042-.582 3.956-.406 5.741.1 1.015.298 1.985.598 2.913-2.333-2.924-4.224-5.949-5.915-8.884-.198-1.463-.27-2.744-.212-3.839.057-1.091.239-1.99.55-2.699a.333.333 0 0 0-.61-.266c-.343.785-.545 1.762-.606 2.931-.037.727-.02 1.531.05 2.416-.438-.779-.865-1.55-1.284-2.307l-.326-.59-.019-.032c-2.227-4.018-4.297-7.655-6.926-10.377l.002.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#D2DFEE"
          fillRule="evenodd"
          d="M200.802 156.841c1.562-1.952 3.759-3.565 4.404-5.978.762-2.848-.915-5.845-.499-8.765.521-3.673 4.066-6.054 5.991-9.229 1.883-3.109 1.001-4.154 1.173-7.784.259-5.469 4.751-12.371 10.739-10.52 6.078 1.882 5.085 7.522 4.016 11.766-.763 3.021-.265 3.456.476 6.484.894 3.656 3.78 7.191 2.573 10.757-.745 2.205-2.912 3.694-3.696 5.887-.887 2.483.187 5.178.601 7.785.873 5.485-.379 10.047-4.371 14.577-.483.458-.987.881-1.513 1.267-5.522-.281-11.685-.537-18.386-.764-.093-.094-.184-.19-.274-.288-3.655-3.981-4.745-10.813-1.234-15.195Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M219.85 119.504a.482.482 0 0 1 .898.342 34.566 34.566 0 0 0-1.216 3.887c.137-.124.28-.244.426-.362a11.166 11.166 0 0 1 2.22-1.373.478.478 0 1 1 .41.867c-.76.36-1.437.776-2.031 1.252a8.25 8.25 0 0 0-1.463 1.51c-.613 2.927-1.016 6.074-1.376 9.39a17.033 17.033 0 0 1 1.781-2.324c1.098-1.191 2.312-2.115 3.644-2.773a.479.479 0 1 1 .426.856c-1.221.604-2.342 1.461-3.361 2.567-1.015 1.1-1.928 2.447-2.74 4.039l-.092.899a359.47 359.47 0 0 1-.67 6.138c-.26 2.164-.561 4.374-.943 6.62 1.039-1.598 2.155-3.013 3.351-4.242 1.753-1.8 3.675-3.204 5.765-4.209a.483.483 0 0 1 .643.224.482.482 0 0 1-.226.641c-1.989.956-3.82 2.294-5.494 4.013-1.668 1.715-3.182 3.81-4.538 6.283-.591 2.978-1.344 6.01-2.343 9.076l-.004.013h-.001a66.038 66.038 0 0 1-1.658 4.533 28.086 28.086 0 0 1 4.628-3.228 27.936 27.936 0 0 1 7.328-2.801.48.48 0 1 1 .218.935 27.036 27.036 0 0 0-7.08 2.703 27.599 27.599 0 0 0-6.023 4.552 63.024 63.024 0 0 1-1.466 3.028l-1.06-.041a63.956 63.956 0 0 0 4.185-9.934c.18-2.338-.098-4.678-.833-7.013-.746-2.37-1.964-4.744-3.653-7.121a.48.48 0 0 1 .783-.554c1.745 2.457 3.007 4.921 3.783 7.387.443 1.401.726 2.802.855 4.202 1.441-5.194 2.241-10.271 2.824-15.117-.563-2.053-1.194-3.792-1.888-5.213-.692-1.415-1.445-2.504-2.255-3.271a.479.479 0 1 1 .658-.696c.899.848 1.719 2.032 2.461 3.548.462.944.894 2.021 1.299 3.233.141-1.28.272-2.541.401-3.783l.1-.966c0-.019.002-.036.006-.054.682-6.583 1.371-12.575 3.322-17.664l-.001.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#C5DEF8"
          fillRule="evenodd"
          d="M216.883 159.413c1.666-.898 3.677-1.371 4.841-2.861 1.377-1.76 1.1-4.342 2.256-6.252 1.454-2.405 4.628-3.016 6.912-4.658 2.235-1.608 1.93-2.598 3.127-5.075 1.803-3.733 6.983-7.213 10.604-4.152 3.675 3.109 1.309 6.744-.695 9.383-1.429 1.879-1.21 2.33-1.593 4.656-.462 2.812.498 6.127-1.401 8.255-1.175 1.317-3.125 1.712-4.323 3.008-1.355 1.467-1.405 3.661-1.891 5.599-.654 2.608-1.799 4.697-3.619 6.381a714.114 714.114 0 0 0-16.573-.901 9.471 9.471 0 0 1-1.296-2.433c-1.363-3.854-.094-8.936 3.651-10.952v.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M241.233 139.037a.364.364 0 0 1 .514-.01c.144.139.148.37.009.514a26.273 26.273 0 0 0-2 2.348c.133-.045.267-.088.404-.126a8.442 8.442 0 0 1 1.955-.299.362.362 0 1 1 .028.724 7.791 7.791 0 0 0-1.787.271 6.269 6.269 0 0 0-1.467.62c-1.296 1.857-2.51 3.93-3.746 6.134a12.725 12.725 0 0 1 1.93-1.09c1.117-.504 2.239-.791 3.361-.856a.365.365 0 0 1 .384.341.366.366 0 0 1-.343.383c-1.028.059-2.063.324-3.103.794-1.033.467-2.069 1.134-3.106 2.002l-.331.6c-.729 1.316-1.477 2.667-2.266 4.037a104.466 104.466 0 0 1-2.645 4.373 20.957 20.957 0 0 1 3.593-1.965c1.756-.736 3.511-1.145 5.266-1.227a.363.363 0 1 1 .034.724c-1.669.078-3.342.469-5.018 1.171-1.671.701-3.347 1.713-5.026 3.036a59.785 59.785 0 0 1-4.326 5.628l-.006.009a51.235 51.235 0 0 1-2.501 2.667 21.15 21.15 0 0 1 4.183-.881 21.208 21.208 0 0 1 5.936.215.363.363 0 1 1-.125.715 20.518 20.518 0 0 0-5.736-.211 20.956 20.956 0 0 0-5.545 1.389 48.87 48.87 0 0 1-2.15 1.866l-1.097-.052a48.34 48.34 0 0 0 6.463-6.161c.82-1.576 1.32-3.287 1.501-5.131.184-1.871.04-3.885-.43-6.041a.363.363 0 0 1 .71-.155c.488 2.227.634 4.316.444 6.263a15.126 15.126 0 0 1-.653 3.181c2.546-3.192 4.611-6.493 6.455-9.695.216-1.597.293-2.994.231-4.189-.062-1.19-.262-2.172-.6-2.945a.365.365 0 0 1 .187-.478.365.365 0 0 1 .479.187c.374.857.594 1.923.662 3.199.04.794.023 1.673-.055 2.636.478-.85.943-1.69 1.401-2.516l.356-.645.02-.035c2.429-4.383 4.689-8.353 7.559-11.322l-.003.003ZM116.388 39.788c-.449 6.154-1.358 7.003-7.236 7.477 5.878.473 6.787 1.322 7.236 7.476.45-6.154 1.359-7.003 7.236-7.476-5.877-.474-6.787-1.323-7.236-7.477Zm23.892 16.229c-.24 3.286-.725 3.738-3.863 3.992 3.138.253 3.623.706 3.863 3.99.24-3.285.726-3.737 3.864-3.99-3.138-.254-3.624-.707-3.864-3.992Zm-10.463-25.285c-.242 3.328-.734 3.787-3.912 4.043 3.178.257 3.67.715 3.912 4.042.243-3.327.734-3.785 3.913-4.042-3.179-.256-3.67-.715-3.913-4.043ZM107.724 140.672c.363 4.985 1.099 5.673 5.862 6.056-4.761.385-5.499 1.072-5.862 6.056-.365-4.985-1.101-5.672-5.862-6.056 4.761-.383 5.498-1.072 5.862-6.056ZM88.367 153.82c.194 2.661.588 3.028 3.13 3.233-2.542.206-2.934.573-3.13 3.234-.194-2.661-.587-3.028-3.13-3.234 2.543-.204 2.937-.572 3.13-3.233Zm8.478-20.484c.197 2.696.594 3.068 3.17 3.276-2.575.207-2.973.579-3.17 3.274-.197-2.696-.595-3.068-3.17-3.274 2.574-.208 2.972-.58 3.17-3.276ZM183.792 128.385c-.278 3.816-.842 4.343-4.487 4.637 3.645.293 4.209.82 4.487 4.638.279-3.817.843-4.345 4.489-4.638-3.646-.294-4.21-.821-4.489-4.637Zm14.819 10.065c-.147 2.038-.449 2.32-2.395 2.476 1.946.158 2.248.438 2.395 2.476.15-2.038.451-2.319 2.397-2.476-1.947-.158-2.248-.438-2.397-2.476Zm-6.489-15.682c-.15 2.063-.455 2.348-2.427 2.507 1.972.16 2.277.444 2.427 2.508.15-2.063.455-2.348 2.427-2.508-1.972-.159-2.277-.443-2.427-2.507ZM140.293 90.754c1.136-2.406 4.57-3.364 6.792-1.894 1.284-1.676 3.537-2.555 5.619-2.19 2.081.363 3.9 1.954 4.538 3.965 1.123-.187 2.405.36 2.817 1.42.411 1.06-.385 2.473-1.523 2.464-.374-.004-.753-.143-1.114-.047-.29.078-.518.294-.746.488-2.855 2.441-7.723 1.963-10.046-.988-1.642 1.428-4.364 1.392-5.966-.08.214.198-2.242.709-2.52.665-.897-.14-2.023-.682-2.173-1.678-.314-2.087 2.868-3.12 4.324-2.125h-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#F0F3FA"
          fillRule="evenodd"
          d="M135.969 92.878c.151.996 1.277 1.538 2.173 1.678.28.044 2.735-.467 2.52-.664 1.603 1.47 4.325 1.507 5.967.079 2.322 2.95 7.19 3.43 10.046.988.228-.194.455-.41.745-.488.362-.096.74.043 1.114.047 1.139.01 1.936-1.404 1.524-2.464-.413-1.06-1.695-1.607-2.818-1.42a5.674 5.674 0 0 0-.918-1.741c.107 1.188-.271 2.421-1.06 3.32a3.823 3.823 0 0 1-1.545 1.084c-.863.314-1.813.262-2.724.15-.611-.074-1.232-.179-1.777-.467-.543-.288-1.006-.79-1.099-1.4-.077-.515.114-1.036.365-1.495a5.948 5.948 0 0 1 1.54-1.82c-1.679.283-3.161 1.518-3.742 3.116-.081.226-.153.467-.327.63-.144.136-.34.201-.531.255a9.247 9.247 0 0 1-2.889.338c-.818-.035-1.728-.24-2.165-.93-.289.42-.708.785-1.213.863-.505.076-1.084-.22-1.191-.718-.086-.392.134-.802.447-1.057.113-.091.517-.233.746-.379-1.535-.127-3.436.86-3.19 2.495h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M146.63 93.972c2.323 2.95 7.191 3.43 10.046.989.228-.195.455-.41.746-.488.361-.097.739.043 1.113.046 1.14.01 1.936-1.404 1.524-2.464-.175.733-.838 1.366-1.534 1.663a2.48 2.48 0 0 1-2.18-.132c-.232.765-.888 1.35-1.626 1.662-.737.312-1.555.382-2.355.393-.556.008-1.114-.013-1.657-.132-.931-.205-1.771-.695-2.578-1.202-.657-.413-1.361-.924-1.504-1.687-.024.401.028.95.005 1.352Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M146.63 93.972c-1.642 1.428-4.364 1.392-5.967-.08.215.198-2.241.709-2.52.665-.896-.14-2.023-.682-2.173-1.678-.246-1.636 1.654-2.622 3.19-2.495-.758.189-1.534.475-1.934 1.145-.4.67-.321 1.654.319 2.1.42.293.977.302 1.484.227.612-.092 1.265-.341 1.548-.89.731.782 1.796 1.189 2.86 1.298 1.064.11 2.146-.083 3.195-.291l-.002-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M69.979 85.478c-3.175-1.749-3.456-6.79-.113-8.483.411-.208 1.023-.53 1.48-.596.232-.034 1.746.161 1.73.5.056-1.155.915-2.14 1.915-2.727 2.51-1.473 6.096-.698 7.771 1.68 1.675 2.379 1.192 6.009-1.049 7.868.891-.399 2.031-.136 2.656.613.625.748.682 1.915.13 2.718 1.178-.679 2.86-.263 3.583.887a9.35 9.35 0 0 1 5.381.446c.379.15.763.339 1.008.663.244.327.3.827.023 1.125-.177.192-.447.264-.702.315-.98.195-1.986.2-2.986.205l-14.01.067c-.47.002-.956.002-1.386-.191-.429-.194-.783-.635-.718-1.1-.683.54-1.487.956-2.354 1.05-.866.094-1.795-.17-2.383-.811a20.723 20.723 0 0 1-8.386.497c-.46-.067-.932-.156-1.32-.41-.387-.255-.673-.718-.587-1.173.086-.457.522-.784.978-.884.455-.1.928-.015 1.384.078-.179-.888.358-1.806 1.117-2.3.758-.497 1.694-.64 2.6-.668 1.434-.046 2.878.17 4.237.631Z"
          clipRule="evenodd"
        />
        <path
          fill="#F0F3FA"
          fillRule="evenodd"
          d="M60.64 87.738c-.456.1-.892.426-.978.883-.086.456.2.917.587 1.173.388.255.86.343 1.32.41 2.789.41 5.664.24 8.386-.497.588.642 1.517.907 2.383.812.867-.094 1.671-.512 2.354-1.05-.065.464.29.906.718 1.1.428.193.915.193 1.386.19 4.671-.021 9.34-.043 14.01-.067.999-.004 2.006-.01 2.986-.205.257-.05.526-.123.702-.315.277-.298.221-.797-.023-1.124-.09-.121-.2-.223-.322-.31-1.42.414-2.987.264-4.463 0-.506-.09-1.044-.21-1.39-.588a.888.888 0 0 1-.148-.224l-.066.012c-.724-1.15-2.406-1.566-3.583-.886.552-.804.496-1.97-.13-2.719-.625-.747-1.765-1.01-2.656-.613 1.674-1.39 2.366-3.768 1.91-5.874-.213 1.449-.72 2.863-1.622 4.012-1.066 1.357-2.731 2.298-4.458 2.25-.232-1.773-1.384-3.402-2.98-4.216.865.66.889 2.096.148 2.89-.741.797-2.035.936-3.014.462-.98-.474-1.645-1.464-1.902-2.52-.382-1.57.156-2.89.978-4.158-.323.13-.654.3-.907.43-3.343 1.693-3.062 6.735.113 8.483-.34-.116-.687-.216-1.036-.3-1.15.302-2.426.492-3.562.8-1.202.327-2.41 1.067-2.773 2.256a5.252 5.252 0 0 0-.583-.422c-.456-.091-.929-.175-1.384-.076h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M69.978 85.479c-3.174-1.75-3.456-6.79-.112-8.484.253-.128.584-.3.907-.429-1.672.812-2.539 2.738-2.568 4.594-.016.96.151 1.98.78 2.71.567.655 1.446.984 2.313 1.036.866.052 1.728-.144 2.558-.395-.981.924-2.695 1.618-3.876.968h-.002ZM84.5 87.053c.55-.803.495-1.97-.131-2.718-.625-.748-1.765-1.01-2.656-.613.658-.12 1.285.497 1.416 1.152.131.654-.14 1.33-.534 1.87-.164.223-.356.435-.599.572-.368.207-.811.216-1.233.196-.965-.046-2.059-.317-2.502-1.173-.085.66.369 1.302.953 1.624.584.322 1.274.386 1.942.4.63.012 1.27-.015 1.873-.198.603-.184 1.114-.592 1.471-1.11v-.002ZM94.471 89.048c.244.327.3.826.023 1.124-.177.193-.447.265-.702.316-.98.194-1.986.2-2.986.205l-14.01.067c-.47.002-.956.002-1.386-.191-.428-.194-.783-.636-.718-1.1.741.519 1.624.621 2.528.655 1.094.04 2.203.039 3.27-.216 1.064-.255 2.094-.787 2.77-1.648a1.968 1.968 0 0 1-.88 1.847c3.16-.388 6.36-.023 9.543-.084.928-.018 2.203-.114 2.547-.975h.001ZM74.692 89.468c-.683.54-1.487.956-2.354 1.05-.866.094-1.795-.17-2.383-.812a20.722 20.722 0 0 1-8.386.498c-.46-.067-.932-.157-1.32-.41-.387-.256-.673-.718-.587-1.174.371.719 1.348.873 2.156.942.93.078 1.872.011 2.782-.2a2.106 2.106 0 0 1-1.115-.635c2.488.607 5.173.385 7.527-.625-.1.455.187.934.595 1.162.407.227.904.24 1.362.151 1.518-.29 2.732-1.728 2.763-3.27.242 1.126-.134 2.606-1.04 3.322Z"
          clipRule="evenodd"
        />
        <path
          fill="#99C5F2"
          fillRule="evenodd"
          d="M126.3 170.486H43.834a2.328 2.328 0 0 1-2.323-2.32V43.132a2.328 2.328 0 0 1 2.323-2.32H126.3a2.327 2.327 0 0 1 2.322 2.32v125.034a2.329 2.329 0 0 1-2.322 2.32Zm-82.466-9.641H126.3a.692.692 0 0 0 .691-.688V43.132c0-.38-.312-.69-.691-.69H43.834c-.38 0-.691.31-.691.69v117.025c0 .379.311.688.69.688Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M126.3 160.846H43.834c-.38 0-.69-.31-.69-.689V43.131c0-.379.31-.69.69-.69H126.3c.38 0 .691.311.691.69v117.025a.692.692 0 0 1-.691.689v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M126.3 160.846H43.834c-.38 0-.69-.31-.69-.689V43.131c0-.379.31-.69.69-.69H126.3c.38 0 .691.311.691.69v117.025a.692.692 0 0 1-.691.689v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#EFF9FC"
          d="M126.273 43.158H43.858v116.974h82.415V43.158Z"
        />
        <path fill="#BBDBFA" d="M126.273 43.158H43.858v6.235h82.415v-6.235Z" />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M58.513 45.383a1.15 1.15 0 0 0-1.152 1.148 1.151 1.151 0 0 0 2.304 0 1.15 1.15 0 0 0-1.152-1.148Zm-10.652 0a1.15 1.15 0 0 0-1.152 1.148 1.151 1.151 0 0 0 2.304 0 1.15 1.15 0 0 0-1.152-1.148Zm5.327 0a1.15 1.15 0 0 0-1.152 1.148 1.151 1.151 0 0 0 2.304 0 1.15 1.15 0 0 0-1.152-1.148Z"
          clipRule="evenodd"
        />
        <path
          fill="#99C5F2"
          d="M41.327 51.54h-.003a.436.436 0 0 0-.436.435v18.901c0 .241.195.436.436.436h.003a.436.436 0 0 0 .436-.436V51.975a.436.436 0 0 0-.436-.436ZM41.327 71.973h-.003a.436.436 0 0 0-.436.436v18.9c0 .242.195.437.436.437h.003a.436.436 0 0 0 .436-.436V72.409a.436.436 0 0 0-.436-.436Z"
        />
        <path
          fill="#99C5F2"
          fillRule="evenodd"
          d="M128.517 68.54v18.9c0 .24.197.437.436.437h.003a.437.437 0 0 0 .436-.436V68.539a.437.437 0 0 0-.436-.436h-.003a.437.437 0 0 0-.436.436Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M94.785 45.02a.807.807 0 0 1-.007.113.4.4 0 0 1-.02.083.097.097 0 0 1-.034.045.077.077 0 0 1-.045.014c-.027 0-.073-.022-.138-.066a2.196 2.196 0 0 0-.643-.29 1.946 1.946 0 0 0-.532-.064c-.246 0-.465.045-.658.133-.195.09-.36.212-.495.37-.136.157-.24.345-.311.562a2.235 2.235 0 0 0-.108.706c0 .284.04.534.118.754a1.6 1.6 0 0 0 .329.554c.14.151.305.266.5.342a1.791 1.791 0 0 0 1.054.067c.14-.032.271-.082.392-.148v-1.293h-1.028c-.04 0-.068-.02-.088-.06a.421.421 0 0 1-.029-.181.74.74 0 0 1 .007-.112.24.24 0 0 1 .022-.075.117.117 0 0 1 .036-.042.086.086 0 0 1 .051-.014h1.408a.218.218 0 0 1 .142.056c.021.018.038.043.048.074a.322.322 0 0 1 .017.11v1.69a.37.37 0 0 1-.03.154c-.02.044-.064.083-.13.115a3.277 3.277 0 0 1-.582.207 2.875 2.875 0 0 1-.679.082c-.344 0-.65-.053-.92-.16a1.904 1.904 0 0 1-.685-.452 2.012 2.012 0 0 1-.427-.706 2.696 2.696 0 0 1-.148-.918c0-.339.053-.671.16-.955.106-.286.256-.529.449-.73.193-.201.424-.356.694-.468.272-.111.572-.165.9-.165.17 0 .328.016.476.045.15.03.281.065.398.104.115.042.21.085.291.132a.9.9 0 0 1 .163.115c.029.03.05.065.061.103a.613.613 0 0 1 .018.168h.003Zm4.436 2.185c0 .27-.04.51-.118.721a1.404 1.404 0 0 1-.873.866c-.21.075-.449.114-.716.114a1.98 1.98 0 0 1-.669-.107 1.34 1.34 0 0 1-.849-.831 2.037 2.037 0 0 1-.117-.719v-2.747a.08.08 0 0 1 .014-.047.089.089 0 0 1 .048-.034.504.504 0 0 1 .09-.02.975.975 0 0 1 .145-.009.99.99 0 0 1 .14.008.44.44 0 0 1 .091.021.086.086 0 0 1 .047.034.08.08 0 0 1 .014.047v2.674c0 .204.025.385.075.537.05.153.123.28.217.381a.886.886 0 0 0 .342.229c.132.052.282.077.45.077.166 0 .32-.024.453-.074a.864.864 0 0 0 .338-.226.989.989 0 0 0 .212-.372 1.66 1.66 0 0 0 .074-.52v-2.705a.08.08 0 0 1 .014-.047c.01-.015.025-.026.049-.034a.561.561 0 0 1 .09-.02.986.986 0 0 1 .144-.009.96.96 0 0 1 .14.008.491.491 0 0 1 .089.021.097.097 0 0 1 .049.034c.01.013.015.029.015.047v2.703h.002Zm1.76 1.549a.088.088 0 0 1-.014.049.095.095 0 0 1-.048.032.487.487 0 0 1-.089.02.997.997 0 0 1-.143.009.967.967 0 0 1-.141-.008.566.566 0 0 1-.093-.021.087.087 0 0 1-.047-.032.078.078 0 0 1-.014-.05v-4.25a.07.07 0 0 1 .015-.048.098.098 0 0 1 .051-.034.565.565 0 0 1 .093-.02.926.926 0 0 1 .136-.009c.057 0 .104.002.143.008a.486.486 0 0 1 .089.021c.023.008.039.019.048.034a.082.082 0 0 1 .014.047v4.252Zm4.591-2.19c0 .383-.049.717-.147 1.003a1.81 1.81 0 0 1-.431.713c-.188.188-.42.329-.695.422-.275.093-.601.14-.981.14h-.938a.246.246 0 0 1-.15-.052c-.046-.037-.071-.099-.071-.187v-3.95c0-.09.023-.15.071-.187a.245.245 0 0 1 .15-.052h1.003c.386 0 .71.049.975.148.264.1.487.244.667.43.179.186.315.41.408.676.093.263.139.563.139.895Zm-.618.025c0-.24-.029-.463-.088-.67a1.474 1.474 0 0 0-.28-.536 1.292 1.292 0 0 0-.483-.352c-.194-.084-.445-.125-.751-.125h-.602v3.448h.608c.284 0 .522-.036.718-.107.194-.07.357-.178.487-.323.131-.146.23-.33.294-.55a2.74 2.74 0 0 0 .099-.783l-.002-.002Zm3.995 2.01a.7.7 0 0 1-.007.109.272.272 0 0 1-.023.077.117.117 0 0 1-.039.044.097.097 0 0 1-.05.014h-2.131a.246.246 0 0 1-.15-.052c-.048-.037-.071-.099-.071-.187v-3.95c0-.09.023-.15.071-.187a.246.246 0 0 1 .15-.052h2.105c.019 0 .035.005.051.014a.09.09 0 0 1 .036.045.438.438 0 0 1 .03.192.471.471 0 0 1-.03.184.105.105 0 0 1-.036.042.092.092 0 0 1-.051.014h-1.736v1.387h1.49a.09.09 0 0 1 .051.015.13.13 0 0 1 .037.043.194.194 0 0 1 .022.074.764.764 0 0 1 0 .22.181.181 0 0 1-.022.072.095.095 0 0 1-.037.04.103.103 0 0 1-.051.012h-1.49v1.585h1.76c.019 0 .035.005.05.013.015.009.029.023.04.041.01.02.018.046.023.077a.627.627 0 0 1 .007.114h.001Zm3.275-.998c0 .206-.038.39-.114.552-.078.162-.183.3-.319.413a1.406 1.406 0 0 1-.48.255 2.006 2.006 0 0 1-.595.085c-.149 0-.287-.013-.414-.039a2.376 2.376 0 0 1-.34-.092 1.5 1.5 0 0 1-.251-.114.669.669 0 0 1-.14-.1.237.237 0 0 1-.059-.104.594.594 0 0 1-.018-.168c0-.05.002-.092.007-.125a.275.275 0 0 1 .02-.079.095.095 0 0 1 .034-.044.093.093 0 0 1 .049-.012c.032 0 .077.02.136.06a2.166 2.166 0 0 0 .556.253c.129.04.279.06.447.06.129 0 .247-.018.352-.052a.826.826 0 0 0 .274-.144.619.619 0 0 0 .177-.231.762.762 0 0 0 .063-.31.58.58 0 0 0-.085-.32.869.869 0 0 0-.227-.235 2.12 2.12 0 0 0-.32-.185l-.368-.17a3.954 3.954 0 0 1-.366-.194 1.555 1.555 0 0 1-.319-.248 1.101 1.101 0 0 1-.315-.8c0-.178.034-.351.1-.496.068-.143.161-.266.281-.364.121-.097.263-.173.428-.224a1.813 1.813 0 0 1 .832-.05 1.81 1.81 0 0 1 .516.164.617.617 0 0 1 .135.084.329.329 0 0 1 .044.051.26.26 0 0 1 .017.05c.004.019.008.042.01.07a1.413 1.413 0 0 1-.001.215.478.478 0 0 1-.016.081.11.11 0 0 1-.028.05.066.066 0 0 1-.043.014c-.026 0-.064-.016-.119-.047a3.704 3.704 0 0 0-.197-.11 1.707 1.707 0 0 0-.276-.108 1.14 1.14 0 0 0-.358-.05.96.96 0 0 0-.322.049.68.68 0 0 0-.227.132.541.541 0 0 0-.133.193.663.663 0 0 0-.045.24c0 .122.028.23.085.317.058.089.133.168.228.236.097.07.204.131.326.19l.371.17c.126.06.249.122.369.193.122.069.229.152.326.246.095.095.17.206.23.335.058.129.087.28.087.458l-.005-.002ZM114.493 127h-27.28a1.88 1.88 0 0 1 1.957-1.437 2.89 2.89 0 0 1 2.677-1.794c.53 0 1.025.142 1.452.389a4.178 4.178 0 0 1 5.106-2.81 5.814 5.814 0 0 1 5.296-3.409 5.813 5.813 0 0 1 5.685 4.592 3.512 3.512 0 0 1 3.626 3.06 1.873 1.873 0 0 1 1.481 1.409Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M174.747 65.746s.047 1.169-.563 1.398c-.61.226-.086 3.537-.184 5.238-.13 2.27.054 4.479-.161 6.739l-2.086 1.294c.013-.832.056-1.543.033-2.223a54.81 54.81 0 0 1-.118 2.276l-2.35 1.19c.741-5.907.398-6.27.77-13.403-.034-.484 4.659-2.509 4.659-2.509Z"
          clipRule="evenodd"
        />
        <path
          fill="#5E919D"
          fillRule="evenodd"
          d="M174.196 95.77s.557 1.93 3.265 5.299c3.134-.045-3.265-5.3-3.265-5.3Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="m159.434 111.401 1.993.367s5.454-8.393 5.611-10.952c.152-2.443 5.067-13.138-.687-19.817-.259-.303-.54-.596-.847-.88l-.032-.031s-.011.014-.028.046c-.118.195-.575 1.02-1.11 2.841-.839 2.85-1.876 8.137-2.122 17.273 0 0-1.339 7.821-2.778 11.153Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M159.434 111.401s-2.135 2.405-2.201 3.38c-.066.976.78 2.205 1.73 2.415.949.207.356-1.296.498-1.899.143-.605.763-1.521.726-1.247-.038.271-.417 1.347-.301 1.518.117.173.424.2.54-.374.115-.574 1.073-1.244.885-1.859-.188-.616-.034-1.091.225-1.915.259-.827.692-1.818.692-1.818l-1.538-.327-1.256 2.127v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#4A75CB"
          fillRule="evenodd"
          d="M169.068 60.706c1.008-1.525 5.007-.672 8.932 1.908 3.925 2.58 6.29 5.908 5.282 7.434-1.005 1.527-5.005.671-8.93-1.908-3.925-2.58-6.291-5.911-5.284-7.434Z"
          clipRule="evenodd"
        />
        <path
          fill="#3B5BB3"
          fillRule="evenodd"
          d="m160.437 173.328 2.117.784s9.193-12.728 10.326-23.925c.201-1.998.135-3.935-.302-5.723l.246-1.417c.073-.423.162-.932.266-1.513.297-1.711.709-4.05 1.179-6.712 1.082-6.13 2.483-13.962 3.574-19.723l-.571-.182-6.171-1.988-1.276-4.042-4.595-1.207s-1.026 2.004-1.944 11.471a71.143 71.143 0 0 0-.44 4.097c-.356 4.533-.383 10.156.438 16.584.21 1.644.476 3.344.807 5.088.24 1.281.278 3.023.175 5.03-.464 9.152-3.829 23.379-3.829 23.379v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#3B5BB3"
          fillRule="evenodd"
          d="m162.845 123.248 9.977 19.8.266-1.514c.298-1.71.71-4.05 1.179-6.711 1.082-6.13 2.484-13.962 3.574-19.723l-.571-.182-6.171-1.988-1.275-4.042-5.489-1.628s-.133 2.425-1.05 11.892a70.32 70.32 0 0 0-.44 4.096Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="m171.279 60.88 7.056 10.684s.806-1.577 1.703-1.012c1.398.882 4.4-2.134 3.774-6.396a11.093 11.093 0 0 0-.146-.794c-1.408-2.025-2.971-4.28-4.092-5.864-3.241-1.952-8.296 3.38-8.296 3.38l.001.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M168.179 82.465c.986.903 2.269 1.712 3.932 2.34 6.23 2.356 9.435-2.735 10.867-6.334-.809-.62-1.62-.845-2.088-.965a20.122 20.122 0 0 0-1.345-.295c-.646-.65-1.414-3.057-1.175-6.598l-.313.04-5.259.695s.013 1.641-.081 3.178c-.074 1.2-.216 2.338-.478 2.588-.408.032-.652.055-.652.055l-.003.005c-.084.103-1.883 2.316-3.406 5.292h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#F08261"
          fillRule="evenodd"
          d="M172.798 71.35s.015 1.64-.08 3.176c2.912.102 4.618-2.447 5.339-3.874l-5.26.698h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M172.027 73.957s6.815-.612 6.854-4.939c.278-4.272 1.351-7.083-3.023-7.613-4.374-.533-5.332 1.043-5.774 2.448-.44 1.405.163 9.852 1.942 10.104h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M170.442 61.49c1.145-1.22 1.93-.888 2.355-.472 3.89-1.823 6.118 1.38 6.118 1.38.262 3.096 2.368 4.993 2.368 4.993s-1.303.692-4.145-.232c-.867-.284-1.615-.958-2.238-1.76 1.045 2.03 2.547 3.542 2.547 3.542-3.35-1.814-4.43-6.693-4.536-7.208-2.674 2.114-1.824 2.909-2.985 5.08 0 0-1.2-3.499.516-5.324v.001ZM153.812 176.875h10.662s.397-1.698-.302-2.851c-.619-1.025-.382-1.606.078-2.45-.483.197-1.107.376-1.795.338-.531-.033-1.093-.272-1.585-.558-.459.522-2.423 2.743-3.038 3.185-.697.5-3.803.321-4.017 2.336h-.003Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M183.959 66.261s3.194-6.346-1.27-8.857c-4.463-2.508-7.731-1.522-10.187 1.545l11.458 7.312h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M163.63 83.58c.853-4.269 3.502-5.492 3.502-5.492s.44-.664 2.901-.77c.382-.013.802-.092 1.267-.13.093-.008.189-.013.286-.02l-.002.005c-.095.142-2.577 3.953-2.438 4.977.139 1.04 9.175.685 9.83.159.526-.426 1.437-3.253 1.777-4.359l.137-.446s3.155.55 4.638 1.775c0 0-1.136 1.246-1.894 2.772-.072.146-.139.291-.204.44a6.412 6.412 0 0 0-.331.957c-.107.423-.01.862.219 1.332.206.432.527.895.897 1.398.242.325.505.67.77 1.04-.187.622-.431 1.367-.703 2.21-.558 1.735-1.222 3.88-1.696 6.187a5.89 5.89 0 0 0 .06 2.619c.085.338.198.67.342.995.227.503.281 1.199.535 1.849 1.031 2.669 2.222 6.151 1.03 7.969-.796 2.326-19.246-3.32-18.004-5.759 0 0-.736-12.79-1.244-16.751a7.028 7.028 0 0 1-.038-.425 7.228 7.228 0 0 1 0-.659c-1.599-.727-1.641-1.875-1.641-1.875l.004.002ZM165.976 58.254c.918-1.473 4.133-1.236 8.012.35a31.912 31.912 0 0 1 4.752 2.456c2.016 1.255 3.773 2.627 5.151 3.972 2.567 2.506 3.82 4.906 2.991 6.24-.925 1.477-4.169 1.227-8.077-.379.317-.346.763-.638 1.231-.341.48.303 1.154.146 1.799-.368.479-.078.832-.27 1.027-.577.146-.232.19-.514.146-.835-.2-1.481-2.306-3.785-5.33-5.669-2.325-1.446-4.635-2.298-6.226-2.4-.925-.06-1.607.134-1.905.613-.259.414-.201.99.115 1.656-.175.697-.172 1.437-.104 2.08-2.966-2.703-4.48-5.368-3.585-6.797l.003-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M176.36 99.613c2.656.852 5.244 1.215 7.296 1.364-.253-.652-.44-1.242-.665-1.746a6.102 6.102 0 0 1-.343-.995 5.918 5.918 0 0 1-.06-2.619c.475-2.309 1.734-6.246 2.292-7.982-1.491-3.318-3.031-1.507-3.031-1.507s-4.505 2.014-6.425 5.734c-1.918 3.718-1.357 7.017.936 7.75Z"
          clipRule="evenodd"
        />
        <path
          fill="#3B5BB3"
          fillRule="evenodd"
          d="M182.112 77.757s-4.292 2.737-5.39 8.508l-1.298-.41s.503-4.12 5.466-8.35l1.22.252h.002ZM166.957 86.412l1.359.088c-.273-5.002 2.242-8.419 2.986-9.313-.465.039-.889.082-1.268.132-3.558 5.138-3.077 9.094-3.077 9.094v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#4567C6"
          fillRule="evenodd"
          d="m165.271 108.097-.964-.416.948-14.334s.921-6.52.933-7.658c.014-1.14.935-1.697.935-1.697s6.765.356 8.67.464c1.907.108 1.714 1.19 1.714 1.19l-.915 3.82c-1.283 5.445 6.056 8.77 6.056 8.77s1.191 3.073 2.115 6.02c1.584 5.051.17 12.296.17 12.296-.241 3.847-.68 20.201-1.137 25.039a143.144 143.144 0 0 1-.371 3.5l-.002.005a.692.692 0 0 0 .113.428 22.988 22.988 0 0 1 1.693 3.553c4.497 11.965-.694 26.702-.694 26.702l-1.348-.544s-2.954-16.399-5.353-23.643c-.408-1.227-.799-2.194-1.157-2.773-1.043-1.68-2.012-4.428-2.892-7.696-1.66-6.176-2.998-14.214-3.889-20.415-.124.006-1.404-8.695-4.61-12.529-.028-.036-.032-.064-.016-.082h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#699DEE"
          fillRule="evenodd"
          d="M176.776 85.762a.569.569 0 1 0 0 .001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M176.678 85.73a.567.567 0 0 0-.372-.713.569.569 0 1 0 .371.713h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#3A5290"
          fillRule="evenodd"
          d="M176.489 85.557a.083.083 0 0 0-.083-.082.083.083 0 0 0-.082.082c0 .044.037.082.083.082a.082.082 0 0 0 .082-.082ZM175.948 85.557a.083.083 0 0 0-.083-.082.084.084 0 0 0-.082.084c0 .045.038.08.083.08a.08.08 0 0 0 .082-.082Z"
          clipRule="evenodd"
        />
        <path
          fill="#699DEE"
          fillRule="evenodd"
          d="M168.391 85.04a.57.57 0 1 0-1.089-.342.57.57 0 0 0 1.09.342h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M168.292 85.007a.565.565 0 0 0-.371-.712.568.568 0 1 0 .37.712h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#3A5290"
          fillRule="evenodd"
          d="M168.102 84.836a.082.082 0 0 0-.082-.082.084.084 0 0 0-.084.082c0 .044.038.081.084.081a.082.082 0 0 0 .082-.08ZM167.562 84.836a.083.083 0 0 0-.166 0 .08.08 0 0 0 .082.081.082.082 0 0 0 .084-.08Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M183.011 68.772s.047 1.016-.563 1.215c-.611.197-.086 3.077-.184 4.556-.129 1.975.007 4.884-.208 6.851l-2.085 1.126c.012-.724.055-1.341.032-1.934a42.508 42.508 0 0 1-.117 1.98l-2.352 1.034c.741-5.137.446-6.442.818-12.645-.034-.422 4.659-2.182 4.659-2.182v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M183.001 102.777s-2.054 1.294-2.355 1.282c-.706-.025-2.098-1.565-3.259-.852-1.158.709-2.294 1.895-1.893 2.368.402.475 1.763-.086 2.416.01.653.094 2.263.894 3.399.517 1.093-.36 3.452-1.848 3.452-1.848L183 102.775l.001.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M185.529 79.28s7.653 9.025 10.186 14.105c0 0-3.045 6.618-12.917 11.994 0 0-.438-.096-1.107-.574-1.044-.745.113-1.287.342-1.437 2.504-1.618 6.88-8.592 7.007-9.198.126-.604-5.485-6.035-7.19-8.039-1.706-2.007 1.029-7.883 3.68-6.85l-.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="m185.529 79.278 3.438 3.352s-.786 4.95-5.989 5.596c0 0-3.557-2.717-1.627-6.11.193-.338 1.893-4.933 4.178-2.84v.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#FAB280"
          fillRule="evenodd"
          d="M180.646 104.059s-.116-.499-.558-.696c-.443-.193-.854-.621-.89-.497-.035.123-.063.333.165.584.229.252.618.678 1.282.607l.001.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M176.703 176.876h10.66s.256-1.623-.302-2.851c-.533-1.181-1.368-1.719-1.168-3.146-.677.695-1.783 1.474-3.324 1.268-.189.305-1.219 1.939-1.85 2.392-.696.501-3.803.321-4.016 2.337ZM172.554 76.154c-.115 1.934.011 4.806-.201 6.732l-.621.558c.013-.723.056-1.341.034-1.934a42.805 42.805 0 0 1-.118 1.98l-2.351 1.034c.445-3.08.416-5.423.468-7.345l2.792-1.025h-.003Z"
          clipRule="evenodd"
        />
        <path
          fill="#3B5BB3"
          fillRule="evenodd"
          d="M171.267 99.565c-1.707.192-3.778.226-4.731-.879-.742-.859-.739-2.762-.537-4.321 1.064.197 2.125.344 3.181.44 1.593.144 3.174.174 4.741.09-.156 2.35-1.009 4.498-2.654 4.67Zm-5.211-5.595a34.62 34.62 0 0 0 3.16.439c1.585.143 3.16.173 4.724.086.009-.28.009-.56 0-.84-3.955.034-6.523-.174-7.705-.628-.069.313-.129.63-.179.943Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M93.468 160.017a61.982 61.982 0 0 0 15.565-.809l-4.209-4.808c-.882-1.131-1.897-2.229-2.838-3.453-.405-.525-1.043-1.542-1.568-1.761-.02.158-.144 1.13-.47 1.34a.186.186 0 0 1-.106.036c-.244-.006-.408-.617-.459-.773-.14-.439-.568-1.026-1.838-1.674a4.069 4.069 0 0 0-1.542 1.358c-.286.412-.478.475-.598.456-.228-.036-.269-.371-.564-.667-.291-.293-.67-.391-.95-.427-.07.027-1.649.646-2.517 1.237-.379.255-.68.523-.68.523-.23.204-.41.391-.535.533a68.43 68.43 0 0 0-7.96 6.991 61.98 61.98 0 0 0 11.27 1.898h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M73.1 161.432a99.116 99.116 0 0 0 24.854-1.292l-6.722-7.679c-1.407-1.807-3.028-3.558-4.53-5.514-.645-.838-1.666-2.461-2.506-2.812-.03.252-.229 1.806-.75 2.142-.085.056-.146.057-.168.056-.39-.008-.65-.983-.73-1.234-.225-.7-.908-1.64-2.938-2.673a6.525 6.525 0 0 0-2.462 2.167c-.457.661-.761.761-.955.731-.364-.06-.428-.592-.9-1.067-.465-.468-1.07-.623-1.517-.681-.948-.237-3.246 1.563-4.02 1.974-.19.1-.666.212-1.24.537a6.964 6.964 0 0 0-.478.302A1920.461 1920.461 0 0 0 55.105 158.4a98.931 98.931 0 0 0 17.993 3.032h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M77.173 146.88c.166.011.324-.183.376-.245.223-.274.209-.625.207-.717-.019-.932.801-3.275 1.98-3.571a.955.955 0 0 1 .506 0c.613.187.817 1.053.974 1.531.613 1.871 2.314 3.348 2.674 3.144.256-.146.284-.729-.097-1.835-.405-1.18-.564-1.029-.102-1.984a43.946 43.946 0 0 1-1.567-2.051c-.362-.505-.974-1.38-3.144-4.873-.384-.616-.696-1.122-.9-1.451l-.94 1.046c-.196.263-.495.663-.855 1.152-2.128 2.885-2.582 3.586-3.328 4.539a18.84 18.84 0 0 1-3.378 3.328c1.04-.101 3.448-2.432 4.47-1.95.806.379.129 1.611-.129 2.319-.274.756-.71 1.811-.74 2.659.314-.206.74-.512 1.204-.933 1.128-1.022 1.48-1.815 1.877-1.715.511.128.465 1.578.91 1.607h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M84.01 145.56c.085-.575.393-.854.393-.854.12-.108.241-.168.32-.201a6.276 6.276 0 0 0-1.332-1.708c.06.089.136.231.113.392-.045.327-.47.578-.814.599-.572.033-.827-.464-1.843-1.315-.371-.313-.887-.554-1.378-.57-.529-.016-.93.338-1.285.691-.368.366-.558.74-.645 1.255-.088.516-.092 1.041-.231 1.55-.066.237-.388.334-.563.147-.08-.085-.175-.252-.28-.31-.123-.067-.296-.009-.419.028-.317.094-.608.259-.937.314-.215.036-.421-.088-.426-.323-.01-.61.117-1.223.052-1.83-.033-.315-.137-.633-.348-.874-.23-.262-.533-.223-.85-.19-.512.055-1.027.091-1.532.197-.057.013-.114.024-.172.038-.822.808-3.675 3.352-3.989 3.932 1.243-.121 4.123-2.91 5.346-2.332.565.265.31 1.83-.153 2.774-.288.588-.593.788-.835 1.553-.18.573-.332 1.484-.05 1.627.246.124.75-.399 1.44-1.115.73-.757.955-1.169 1.7-1.825.287-.255.542-.446.711-.569.171.226.35.501.514.824.345.687.483 1.325.54 1.792.09-.15.209-.369.319-.645.166-.42.248-.754.246-.857-.022-1.081.897-4.917 2.06-5.071.319-.042.59.201.927.504.86.772 1.043 1.866 1.096 2.135.202 1.004 1.033 2.488 3.845 4.56-1.089-2.077-1.624-3.739-1.538-4.323h-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M94.614 160.68a2.841 2.841 0 0 1 1.506-1.094 2.775 2.775 0 0 1 1.31-.052 2.365 2.365 0 0 1 1.19-1.04 2.383 2.383 0 0 1 1.624-.029c.158-.222.448-.541.893-.669.326-.092.643-.055.832-.033.292.033.525.109.683.17.065-.168.221-.503.566-.776.12-.097.651-.52 1.336-.373.515.112.81.479.899.6-.003-.145-.008-.828.503-1.33.553-.543 1.369-.542 1.893-.354 1.153.415 1.465 1.949 1.465 2.798 0 .775-.263 1.382-.446 1.723l-.018-.039-14.235.499-.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M71.755 160.266c.609-.673 1.434-1.702 2.043-2.375.48-1.705.742-3.055 1.221-4.76-1.042 1.535-1.656 2.253-1.839 2.157-.24-.125.254-1.642 1.482-4.552a13.4 13.4 0 0 0-1.767 2.248c-.802 1.282-.992 2.076-1.596 3.271-.446.884-.971 2.174-2.21 3.526.456-.003.808-.02 1.44.115.471.1.882.234 1.225.37h.001ZM73.522 144.99a23.969 23.969 0 0 1-2.82 4.353c-.741.905-1.782 2.034-1.71 2.106.087.087 1.634-1.637 2.051-1.366.515.334-1.054 3.473-.884 3.556.089.042.602-.745 1.996-3.3a20.773 20.773 0 0 0 1.367-5.348v-.001ZM79.992 157.506c.968-.361 2.3-.729 3.904-.796 3.362-.143 5.92 1.112 7.096 1.792l-2.621-2.674a11.88 11.88 0 0 0-8.379 1.678ZM69.746 146.692c-.96.86-1.588 1.515-1.731 1.664-.766.802-1.747 1.837-2.693 3.37-.31.501-.538.927-.684 1.217.448.165.898.327 1.346.491-.197.018-.885.108-1.411.682-.27.295-.395.605-.456.804.865.151 1.729.302 2.593.455l-2.95.724c-.662.498-1.325.997-1.988 1.493-.452-1.09-1.46-1.768-2.48-1.706-.916.056-1.503.691-1.646.853-.035-.262-.07-.526-.107-.789l10.252-9.451c.852-.932 2.574-2.507 4.717-2.404.14.007.281.021.427.043-.836.594-1.95 1.44-3.192 2.553l.003.001ZM78.88 143.228c.402.045.96.172 1.439.569.466.386.648.851.784 1.166.44 1.026.97 1.737 2.023 3.159a12.536 12.536 0 0 0 2.024 2.133c.009-.37.018-.74.029-1.11a24.015 24.015 0 0 1-4.046-5.574 3.226 3.226 0 0 0-1.368-.967c-.092 0-.24.01-.398.084a.98.98 0 0 0-.485.541l-.002-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M79.813 143.342c-.15.186-.36.456-.598.789-.597.833-.895 1.25-1.026 1.622-.326.929.038 1.357-.407 2.283a3.148 3.148 0 0 1-.427.661c.01-.146.024-.361.043-.619.123-1.73.188-2.602.32-3.029.15-.481.478-1.175 1.282-1.899l.813.193v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M71.285 143.96c-.638 1.838-.76 2.291-.727 2.304.049.019.304-1.004 1.133-1.771.611-.563 1.332-.804 1.903-.917l-2.309.384Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M68.464 145.859a81.383 81.383 0 0 0 3.262-3.798c1.482-1.836 2.067-2.727 3.428-4.288a43.638 43.638 0 0 1 2.886-3.007 41.822 41.822 0 0 0-2.095 2.773c-2.358 3.407-2.829 5.161-4.915 6.826a10.319 10.319 0 0 1-2.566 1.494Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M77.997 134.788a63.723 63.723 0 0 0 2.8 4.928 64.403 64.403 0 0 0 3.527 5.056l.598-.129a81.153 81.153 0 0 1-6.925-9.856v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M96.213 150.915c.1.006.195-.109.226-.147.135-.164.126-.375.125-.431-.01-.56.482-1.969 1.191-2.148a.547.547 0 0 1 .304 0c.37.111.493.633.587.921.37 1.125 1.391 2.013 1.608 1.89.155-.088.172-.438-.058-1.105-.244-.709-.339-.617-.061-1.192a25.962 25.962 0 0 1-.942-1.235c-.218-.303-.588-.83-1.892-2.931l-.54-.873-.566.629-.514.692c-1.28 1.736-1.554 2.158-2.002 2.73-.415.53-1.06 1.253-2.031 2.002.625-.06 2.073-1.463 2.688-1.173.485.229.078.97-.078 1.395-.164.455-.426 1.09-.444 1.6a6.03 6.03 0 0 0 .723-.561c.68-.616.89-1.092 1.129-1.033.306.078.279.951.547.968v.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M100.325 150.122c.051-.346.237-.514.237-.514a.695.695 0 0 1 .19-.12 3.808 3.808 0 0 0-.8-1.028c.036.054.082.14.068.237-.027.196-.282.347-.49.36-.344.019-.497-.279-1.108-.791-.223-.188-.533-.334-.83-.342-.316-.01-.558.204-.772.415-.22.222-.335.446-.387.755-.053.31-.056.627-.14.932-.04.142-.233.2-.339.089-.047-.051-.106-.151-.168-.187-.073-.04-.178-.006-.252.018-.19.055-.366.155-.564.189-.128.022-.254-.054-.256-.195-.006-.366.07-.735.031-1.101a.937.937 0 0 0-.21-.525c-.138-.158-.32-.135-.511-.114-.308.034-.617.055-.92.117l-.104.023c-.494.486-2.21 2.016-2.4 2.365.748-.073 2.481-1.749 3.216-1.404.34.161.186 1.101-.093 1.669-.173.354-.357.474-.503.935-.109.345-.2.892-.029.978.147.074.451-.24.866-.671.439-.455.574-.703 1.022-1.098.174-.153.327-.269.43-.342a3.297 3.297 0 0 1 .634 1.574 2.83 2.83 0 0 0 .19-.388c.1-.252.15-.453.15-.516-.013-.65.54-2.957 1.237-3.05.192-.026.356.122.559.303.518.465.627 1.123.66 1.283.122.605.62 1.497 2.313 2.744-.654-1.25-.978-2.249-.927-2.601v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M90.976 150.301a48.74 48.74 0 0 0 1.962-2.284c.89-1.104 1.243-1.64 2.061-2.579a26.826 26.826 0 0 1 1.735-1.809c-.472.575-.89 1.135-1.258 1.668-1.42 2.048-1.702 3.105-2.958 4.107a6.28 6.28 0 0 1-1.542.898v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M96.709 143.641a38.683 38.683 0 0 0 3.805 6.005l.36-.078a48.9 48.9 0 0 1-4.165-5.927Z"
          clipRule="evenodd"
        />
        <path
          fill="#B3C4E5"
          fillRule="evenodd"
          d="m68.45 152.898 1.81.711a789.9 789.9 0 0 1-1.486-.325l-.325-.386Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M95.716 157.422c-.948-1.079-1.447-1.597-1.496-1.557-.05.042.382.689 1.304 1.941l-2.906.385a13.197 13.197 0 0 1 4.51 1.045l-1.41-1.814h-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M78.424 141.635c.557 2.019 1.112 4.039 1.668 6.06v-5.59l-1.668-.469v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M94.605 160.676c.31-.25.917-.666 1.784-.833.504-.096.941-.078 1.257-.039.09-.165.441-.748 1.19-1.04a2.38 2.38 0 0 1 1.623-.029c.157-.222.448-.541.893-.669.326-.092.643-.055.833-.033.292.033.525.108.683.17.064-.168.22-.502.565-.776.12-.097.651-.52 1.336-.371.515.11.81.477.899.598-.003-.145-.007-.828.503-1.33.553-.543 1.369-.543 1.893-.354 1.153.413 1.466 1.948 1.465 2.797 0 .775-.263 1.383-.446 1.724l-.009-.019-.009-.02-14.46.225v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="m73.058 161.445 3.415.188.014-.692-1.019.223c-.574-1.067-.518-1.592-.334-1.874.102-.156.287-.306.254-.348-.04-.056-.384.132-.78.348-.288.159-.523.299-.683.397a3.045 3.045 0 0 1-.127-1.794l-.954 1.064c-1.31.242-2.444.584-3.754.826.586-.036 1.952-.144 3.236.897.305.248.544.514.731.765h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M73.058 161.445c-.206-.296-.866-1.224-2.113-1.587a3.916 3.916 0 0 0-1.855-.076 3.358 3.358 0 0 0-1.684-1.473 3.362 3.362 0 0 0-2.298-.04c-.224-.316-.635-.766-1.264-.946-.462-.132-.912-.079-1.18-.049a3.958 3.958 0 0 0-.966.241 2.617 2.617 0 0 0-.8-1.1c-.17-.135-.921-.733-1.892-.526-.728.158-1.146.676-1.272.847.006-.205.01-1.171-.71-1.882-.783-.768-1.939-.768-2.682-.501-1.631.587-2.075 2.758-2.074 3.96 0 1.099.373 1.957.632 2.441.01-.019.017-.037.026-.056 6.718.237 13.332.499 20.049.734l.085.013h-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M73.058 161.445c-.454-.326-1.197-.74-2.312-.959a6.079 6.079 0 0 0-1.855-.075 3.346 3.346 0 0 0-1.685-1.472 3.357 3.357 0 0 0-2.297-.042c-.224-.315-.635-.767-1.264-.946-.463-.132-.913-.08-1.18-.048a3.928 3.928 0 0 0-.966.241 2.61 2.61 0 0 0-.8-1.1c-.17-.136-.921-.734-1.892-.527-.728.157-1.146.676-1.273.848.006-.205.01-1.173-.71-1.883-.783-.769-1.94-.769-2.682-.503-1.632.588-2.075 2.759-2.074 3.961a5.18 5.18 0 0 0 .632 2.441c.003-.008 13.559 0 20.358.063v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M84.113 120.135c.308-1.065.012-2.183-1.212-2.944-1.328-.825-3.186-.757-4.536.053-.305-.589-.89-1.088-1.445-1.423a1.734 1.734 0 0 0-.987-.269c.065-1.04-.252-2.095-1-2.816a3.333 3.333 0 0 0-1.973-.916c-.153-.732-.533-1.442-1.052-1.85-.498-.391-1.291-.663-1.945-.506-.97-1.174-2.945-1.355-4.377-1.173-1.962.252-3.01 1.448-3.363 3.093-.677-.404-1.569-.353-2.236.225-.609.524-.893 1.403-.735 2.18-.847-.267-1.793-.172-2.654.4-.541.359-.93.87-1.182 1.449-1.311-.892-3.183-1.166-4.536-.691-2.205.774-3.044 2.653-2.89 4.674-.404-.103-.817-.066-1.198.255-.311.264-.447.697-.427 1.127-2.477.241-4.38 2.982-3.926 5.388.239 1.269 1.063 2.333 2.287 2.787.154.056.32.106.496.146.085.817.354 1.602.865 2.263 1.093 1.414 2.96.916 4.194-.018.15.254.393.441.773.494.641.092 1.287-.317 1.66-.861.276.971.761 1.86 1.681 2.403.897.531 1.986.482 2.94.097.414 1.249 1.702 2.393 2.83 2.619 1.876.376 3.487-.82 4.525-2.327 1.218 1.187 2.838 1.911 4.633 1.922 1.416.009 3.128-.678 3.865-1.881.793.144 1.821-.195 2.308-.648.395-.369.702-1.138.78-1.908.949.132 1.957.023 2.717-.251 1.61-.579 3.006-2.062 3.294-3.763 1.372-.309 2.726-1.459 3.18-2.618.573-1.46.12-4.013-1.351-4.718l-.003.006Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M77.338 128.897c-2.301 3.123-5.982-.276-5.982-.276s-.921 1.194-4.003 2.526c-3.083 1.332-5.2-3.329-5.2-3.329s-1.637 3.148-4.485 2.28c-2.848-.868-1.68-5.152-1.68-5.152s-1.599 2.043-4.04 0c-2.44-2.044 2.108-5.235 2.108-5.235s-2.944.092-2.815-2.939c.047-1.101.505-1.716 1.069-2.055a4.388 4.388 0 0 0-1.431.229c-2.205.775-3.044 2.653-2.89 4.675-.403-.103-.817-.066-1.198.255-.311.263-.447.697-.427 1.127-2.477.241-4.38 2.982-3.926 5.387.239 1.269 1.063 2.333 2.287 2.787.154.056.32.106.496.146.085.817.354 1.601.865 2.262 1.093 1.414 2.96.916 4.194-.017.15.254.393.44.773.494.641.091 1.287-.318 1.66-.862.276.972.761 1.861 1.681 2.403.897.531 1.986.482 2.94.098.414 1.248 1.702 2.392 2.83 2.618 1.876.377 3.487-.82 4.525-2.326 1.218 1.187 2.838 1.91 4.633 1.921 1.416.01 3.128-.678 3.865-1.881.793.144 1.821-.195 2.308-.648.396-.368.702-1.138.78-1.908.949.133 1.957.024 2.717-.251a5.366 5.366 0 0 0 2.6-2.056c-2.486 1.407-4.253-.281-4.253-.281l-.001.008Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M64.566 142.195c.54-1.271 1.076-2.544 1.576-3.834 1.328-3.431 1.843-7.249 3.787-10.403.036-.03.068-.062.105-.093.43-.362.87-.706 1.296-1.061 1.559-.528 3.229-.233 4.863-.619 1.395-.328 2.635-1.074 3.337-2.35.022-.04-.03-.082-.065-.05-1.459 1.416-3.346 1.877-5.337 1.882-.528 0-1.082-.016-1.625.023.087-.098.173-.196.256-.298.82-1.025 1.375-2.228 1.82-3.454.073-.197-.234-.274-.312-.085-.59 1.439-1.56 2.66-2.76 3.649-1.028.846-2.233 1.453-3.112 2.476-.411.479-.704 1.02-.932 1.596-.204-1.199-.592-2.351-.94-3.531-.03-.109-.057-.214-.085-.321a12.93 12.93 0 0 1-.252-1.926v-.004c0-.17.006-.339.017-.507.404-1.645.678-3.472 2.183-4.392 1.16-.71 2.346-1.01 2.919-2.346.052-.124-.112-.231-.186-.109-.97 1.589-3.23 1.403-4.337 2.866-.32.424-.582.941-.787 1.498-.059-.487-.141-.971-.266-1.449-.506-1.947-1.672-3.76-1.366-5.843.014-.096-.13-.141-.15-.042-.266 1.283-.117 2.502.209 3.761.466 1.796.802 3.487.87 5.351.057 1.492.11 2.992.506 4.439.166.606.368 1.192.538 1.774l.078.417c.093.518.145 1.033.165 1.545-.21 1.543-.786 3.047-1.47 4.472a.583.583 0 0 1-.2.178c-.03.015-.055.022-.084.034-1.129-.724-1.964-2.102-2.905-3.02-.956-.931-1.915-1.878-2.528-3.007-.442-1.21-.406-2.547.02-3.771.76-2.18 3.67-3.573 3.536-6.017-.006-.108-.175-.145-.2-.026-.37 1.863-2.103 2.565-3.145 3.981a6.45 6.45 0 0 0-.351.536c.068-1.179-.087-2.304-.707-3.372-.047-.08-.163-.01-.123.07 1.328 2.736-.9 5.685-.388 8.473-.87-.629-1.755-1.239-2.517-2.001a12.693 12.693 0 0 1-1.744-2.218 17.685 17.685 0 0 1-1.106-2.6c-.254-.776-.592-1.578-1.344-1.983-.035-.018-.086.022-.06.059.72.975.825 2.089 1.219 3.202.17.48.392.957.667 1.401.343.667.761 1.279 1.238 1.85-.896-.344-1.85-.41-2.77-.671-1.414-.403-2.608-1.223-3.438-2.44-.06-.089-.2-.01-.145.085 1.043 1.81 2.513 2.878 4.545 3.363 2.02.483 3.525 1.622 5.088 2.773 2.473 2.329 4.87 4.663 5.044 8.272.214 4.43-2.49 8.07-4.622 11.7-1.975 3.365-2.576 6.982-1.826 10.788h8.37c-3.867-5.671-2.417-12.503-.07-18.665l.003-.006Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M65.88 124.949c-.23-1.285-.092-2.434-.092-3.169 0-.735-.414-2.755-.989-3.995-.575-1.239-.585-4.32-.585-4.32-.266 1.283-.118 2.501.209 3.761.465 1.796.802 3.487.87 5.351.056 1.491.11 2.991.506 4.439.166.606.368 1.191.537 1.773.027.139.054.278.078.418.094.518.145 1.032.166 1.545-.21 1.542-.786 3.047-1.47 4.471l-.588 1.492s-3.21-4.098-4.038-4.822c-.828-.723-1.346-1.86-1.622-2.617-.276-.758-.068-3.099.31-4.305.38-1.205 2.762-3.169 3.244-3.857.214-.305.38-.939.498-1.56-.052-.049-.147-.046-.165.04-.37 1.864-2.103 2.565-3.146 3.982a6.485 6.485 0 0 0-.35.535c.068-1.179-.087-2.303-.708-3.372-.046-.08-.162-.009-.123.071 1.329 2.736-.9 5.684-.387 8.473l.275.712s-1.963-1.236-2.416-1.891c-.453-.653-1.69-1.893-2.139-2.617-.448-.724-1.414-2.996-1.725-3.962-.132-.408-.449-.753-.772-1.017a.03.03 0 0 0 .005.031c.72.975.825 2.089 1.218 3.201.17.48.393.958.668 1.402.343.666.76 1.278 1.238 1.85l.473.528s-1.415-.345-2.692-.723c-1.276-.379-1.76-.62-3.248-2.027a9.279 9.279 0 0 1-.863-.91.076.076 0 0 0-.022.104c1.043 1.81 2.513 2.878 4.545 3.364 2.02.482 3.525 1.621 5.088 2.772 2.473 2.329 4.87 4.663 5.044 8.273.214 4.43-2.49 8.069-4.622 11.7-1.975 3.365-2.577 6.981-1.826 10.787h4.207c-.739-2.794-1.619-7.115-.665-9.138 1.472-3.123 3.313-9.782 4.416-11.893 1.104-2.113 2.99-7.762 3.128-8.68.139-.919-1.242-4.913-1.472-6.2h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M118.236 141.781c.669-.508 1.173-1.22.896-2.114-.156-.502-.602-.892-1.12-1.108a2.808 2.808 0 0 0-.04-1.278c-.279-1.129-.809-2.346-1.742-3.084-1.346-1.065-3.2-.756-4.144.45a2.138 2.138 0 0 0-1.434-.252c-.565.103-1.125.515-1.453 1.036-1.141-.762-2.757-.759-4.082.078-1.374.868-2.3 2.623-2.074 4.186-2.245 1.007-3.243 5.014-2.687 7.075.587 2.179 2.647 3.512 4.647 3.326.199 2.145 2.123 3.867 4.549 3.846 2.842-.024 4.94-2.063 4.886-4.532a4.215 4.215 0 0 0 1.953-.507c1.139-.614 2.361-1.699 2.707-2.983.336-1.242-.066-2.822-.86-4.137l-.002-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M105.003 150.094c.2 2.144 2.124 3.867 4.55 3.846 2.841-.024 4.94-2.063 4.885-4.532a4.21 4.21 0 0 0 1.953-.508c1.14-.613 2.361-1.698 2.707-2.982.041-.15.07-.306.09-.466-1.691.979-3.281-1.274-3.281-1.274s-.585 2.872-3.12 2.58c-2.535-.292-2.828-4.38-2.828-4.38s-2.242.682-2.369-3.6c-.046-1.55.343-2.78.855-3.719-1.036-.354-2.273-.217-3.326.448-1.375.868-2.301 2.623-2.074 4.185-2.246 1.008-3.244 5.015-2.687 7.075.586 2.18 2.646 3.513 4.646 3.327h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M107.735 130.597c-1.019-1.121-2.557-1.857-4.06-2.027a3.873 3.873 0 0 0-.788-.01c-1.127-2.258-4.946-4.252-6.647-1.304a2.01 2.01 0 0 0-1.24-.121c-.985.236-1.171 1.163-.986 2.004-1.3.174-2.732 1.457-3.166 2.51-.701 1.7-.07 4.33 1.521 5.39-.777 1.796-.184 3.739 1.642 5.181 1.187.938 2.8.937 3.973.219.273.423.675.765 1.135.914.48.153 1.064.091 1.538-.142.424.397.956.692 1.561.848 1.797.459 3.664-.462 4.872-1.753 1.548-1.654 1.802-4.054.882-5.778 1.333-1.711 1.49-4.033-.237-5.93v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M107.09 142.306a5.247 5.247 0 0 0 1.365-2.858c-3.355 1.936-4.804-2.418-4.804-2.418s-.247 3.309-3.87 2.818c-3.621-.494-2.5-4.872-2.5-4.872s-1.462 1.173-4.192-1.001c-1.995-1.589-1.266-3.181-.587-4.205-.752.51-1.39 1.237-1.654 1.88-.701 1.699-.07 4.329 1.521 5.389-.777 1.796-.184 3.74 1.642 5.182 1.187.937 2.8.936 3.973.219.273.423.675.765 1.135.913.48.153 1.064.092 1.538-.141a3.581 3.581 0 0 0 1.894.916c.394-.015.819-.016 1.277-.002 1.243-.193 2.415-.913 3.262-1.818v-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M118.029 112.347c-.561-1.322-1.584-2.315-2.86-2.887-.291-2.58-1.855-4.849-4.735-5.143-1.389-.143-2.844.36-3.902 1.271-.507-1.017-1.638-1.51-2.764-.86-.672.388-1.065 1.11-1.202 1.889-2.254-.823-5.596 1.578-6.64 3.286-1.186 1.94-1.475 5.248-.145 7.261-.516.835-.415 2.106.09 3.03.413.761 1.05 1.631 1.962 1.759.405.056.806.004 1.173-.131.253.859.765 1.628 1.541 2.098a3.83 3.83 0 0 0 3.332.27c.519.628 1.318 1.041 2.251 1.126.843.077 1.616-.277 2.147-.856.523.656 1.204 1.167 2.133 1.398 1.735.432 3.471-.647 4.702-1.776 1.573-1.444 1.848-3.154 1.265-5.156a14.29 14.29 0 0 0-.09-.294c1.897-1.405 2.763-3.873 1.741-6.284l.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#A4D0FC"
          fillRule="evenodd"
          d="M108.277 124.459c.523.656 1.204 1.167 2.133 1.398 1.735.432 3.471-.647 4.702-1.776.979-.898 1.455-1.9 1.535-3.01-.587.501-1.449.891-2.691.771-3.023-.292-3.315-5.256-3.315-5.256s-1.124 3.21-4.926 1.789c-3.802-1.422-2.486-4.514-2.486-4.514s-2.827 1.557-4.777-1.788c-1.124-1.929.116-3.917 1.37-5.257-1.647.643-3.234 2.003-3.896 3.086-1.186 1.94-1.475 5.248-.145 7.262-.516.834-.415 2.106.09 3.03.413.76 1.05 1.63 1.962 1.758.405.057.806.005 1.173-.131.253.859.765 1.628 1.541 2.098a3.83 3.83 0 0 0 3.332.27c.519.628 1.318 1.041 2.251 1.127.843.076 1.616-.277 2.147-.857Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M114.561 141.717c-1.077.795-2.434 1.197-3.362 2.205l-.155-.096c.723-1.948 1.405-3.909 2.145-5.856.052-.136-.173-.231-.239-.099-1.432 2.889-2.943 5.701-4.204 8.676-.366.862-.768 1.734-1.169 2.616a71.168 71.168 0 0 0-.362-2.7 398.585 398.585 0 0 1-.541-9.652c-.039-.927-.074-1.854-.108-2.783a10.497 10.497 0 0 1 .607-3.926c.295-.814.636-1.612 1.032-2.387 1.572-3.08 3.672-5.79 4.525-9.195.028-.112-.136-.156-.172-.048-.51 1.52-1.326 2.867-2.221 4.172.018-1.433-.464-3.094-.681-4.221-.016-.085-.147-.063-.147.02a56.68 56.68 0 0 0 .064 3.135c.058 1.32-.35 2.618-1.103 3.704-.66.953-1.282 1.926-1.78 2.974-.101.211-.196.425-.288.639l-.098-3.308c.01-.946.018-1.893.007-2.839.003-.262.002-.525.003-.787.078-1.553.103-3.116.39-4.654.472-2.527 1.76-4.794 2.183-7.316.021-.121-.146-.172-.184-.051-.469 1.481-1.432 2.702-2.048 4.114a12.895 12.895 0 0 0-.562 1.576 48.81 48.81 0 0 0-.587-4.61c-.014-.077-.126-.052-.13.018-.194 2.611-.245 5.234-.256 7.861a16.824 16.824 0 0 0-.964-1.441c-1.262-1.716-2.844-3.283-4.303-4.83-.026-.028-.07.009-.05.04.836 1.289 1.731 2.539 2.593 3.81-1.125-.548-2.526-.384-3.76-.397-.067 0-.077.096-.012.112 1.563.368 3.205.404 4.333 1.644.441.486.809 1.018 1.167 1.554.172.372.335.749.488 1.129.07.175.127.331.184.471.214 1.457.297 2.929.32 4.407-.425 5.183-1.028 10.377-1.392 15.561a37.561 37.561 0 0 0-1.01-1.872 20.695 20.695 0 0 0-1.118-1.702.308.308 0 0 0-.065-.088c-1.646-2.251-3.626-4.264-4.973-6.694-.026-.045-.11-.014-.088.037.658 1.582 1.685 2.95 2.566 4.412.198.328.39.659.587.99a5.705 5.705 0 0 0-.787-.392c-1.251-.49-2.604-.787-3.901-1.137-.052-.014-.088.062-.038.088 1.216.581 2.453 1.115 3.667 1.695.216.103.42.236.619.382a8.658 8.658 0 0 1 2.4 2.737l.272.482c.271.486.536.975.793 1.467a7.447 7.447 0 0 1 .842 3.743 98.06 98.06 0 0 0-.084 3.871c-.421 3.974-.331 8.069-.097 11.987h6.345l-.064-.155c-.472-2.801-1.122-5.579-1.578-8.387v-.006a2.02 2.02 0 0 1 .114-1.065c.57-1.466 1.097-2.957 1.681-4.361l.009-.024a7.745 7.745 0 0 1 2.502-3.215c.097-.074.195-.148.291-.223.706-.544 1.287-1.221 1.991-1.765.029-.022-.01-.072-.039-.05v.003Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M114.561 141.717c-1.077.795-2.434 1.198-3.362 2.206l-.081-.051c.002.001.005.002.007.005-.009-.007-.031-.02-.081-.051.723-1.949 1.405-3.91 2.145-5.856a.112.112 0 0 0-.006-.092c-.566 1.295-1.991 4.581-2.495 5.934-.634 1.702-2.242 5.352-2.242 5.352s-.488 1.922-.456 2.846l.001.015c.008-.229.051-.457.134-.671.571-1.466 1.098-2.957 1.682-4.362l.009-.023a7.745 7.745 0 0 1 2.502-3.215l.291-.223c.706-.545 1.287-1.221 1.991-1.765.029-.022-.01-.072-.039-.05v.001Zm-3.443 2.155c-.009-.006-.006-.005 0 0Zm-2.477-17.821c.878-1.12 1.146-2.214 1.293-3.455.128-1.098-.302-3.375-.363-4.222-.032.007-.061.03-.061.07a56.699 56.699 0 0 0 .064 3.135c.058 1.319-.35 2.617-1.103 3.703-.66.953-1.282 1.927-1.78 2.975-.101.211-.196.425-.288.638l.142 1.171s1.218-2.895 2.096-4.015Zm-2.238 2.844v-.008.008Zm1.185 32.146h-4.278c-.233-3.919-.323-8.013.097-11.987.002-1.289.031-2.58.084-3.871a7.458 7.458 0 0 0-.842-3.743 60.762 60.762 0 0 0-.793-1.466l-.272-.483a8.636 8.636 0 0 0-2.4-2.737 3.919 3.919 0 0 0-.62-.382c-1.213-.58-2.45-1.116-3.666-1.695-.05-.024-.013-.101.038-.088 1.296.351 2.65.647 3.901 1.137.28.11.538.244.787.392-.197-.33-.388-.661-.587-.989-.881-1.463-1.908-2.829-2.566-4.412-.021-.051.061-.083.088-.037.21.378.437.741.672 1.1.49.979 1.127 2.096 1.83 2.961 1.586 1.947 2.511 3.285 3.145 4.477.634 1.192 1.658 3.577 1.658 3.577s-.147-.931-.14-1.759c.365-5.185.966-10.379 1.391-15.562-.021-1.478-.104-2.95-.319-4.407-.057-.14-.114-.296-.185-.471-.153-.38-.316-.757-.487-1.129-.358-.536-.726-1.068-1.167-1.554-1.128-1.24-2.77-1.276-4.333-1.644-.066-.016-.056-.112.013-.111 1.233.013 2.633-.151 3.759.398-.862-1.272-1.757-2.523-2.592-3.812-.02-.031.023-.067.048-.039l.403.424c.922 1.172 2.263 2.853 2.607 3.337.537.754 1.803 2.409 2.34 3.748l-.082-1.304c.012-2.536.063-5.071.243-7.594.107 1.653.246 3.914.303 5.248.097 2.287.146 10.656-.147 12.895-.292 2.238-1.024 11.679-.292 18.395.471 4.324 1.608 9.821 2.36 13.188l.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#2C3A64"
          fillRule="evenodd"
          d="M53.874 129.801c.006-.09.026-.326.104-.471 0 0-.004.245.03.369.036.125-.134.102-.134.102Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M151.371 175.209c-5.771 2.042-49.287 1.294-58.17.919-30.64-1.294-14.399-8.49-9.493-9.203 12.561-1.827 8.944-8.945-4.311-6.465 1.037.068 3.02.563 2.484 2.013-.88 2.366-13.538 3.268-14.842 6.513-1.305 3.244-1.285 7.356 4.652 9.095 19.043 5.58 70.771.496 79.68-2.872Z"
          clipRule="evenodd"
        />
        <path
          fill="#FC9774"
          fillRule="evenodd"
          d="M61.421 60.602c3.382 0 6.443 1.367 8.659 3.579a12.172 12.172 0 0 1 3.586 8.642c0 3.375-1.37 6.43-3.586 8.642a12.218 12.218 0 0 1-8.659 3.58 12.218 12.218 0 0 1-8.658-3.58 12.172 12.172 0 0 1-3.586-8.642c0-3.375 1.371-6.432 3.586-8.642a12.217 12.217 0 0 1 8.658-3.58Zm6.642 14.084h2.834v-.63h-2.08v-1.01h1.867v-.629h-1.867v-.826h2.007v-.63h-2.761v3.725ZM63.7 64.276v1.669a7.28 7.28 0 0 1 4.479 4.233h1.699a8.838 8.838 0 0 0-2.193-3.607 8.857 8.857 0 0 0-3.985-2.295Zm-4.56 1.669v-1.67a8.857 8.857 0 0 0-3.986 2.296 8.853 8.853 0 0 0-2.193 3.607h1.7a7.258 7.258 0 0 1 4.478-4.233Zm10.737 9.526h-1.7a7.22 7.22 0 0 1-1.626 2.475 7.258 7.258 0 0 1-2.852 1.758v1.669a8.866 8.866 0 0 0 3.985-2.295 8.844 8.844 0 0 0 2.193-3.608ZM59.14 81.374v-1.67a7.264 7.264 0 0 1-4.478-4.232h-1.7a8.825 8.825 0 0 0 2.193 3.607 8.856 8.856 0 0 0 3.986 2.295h-.002Zm10.417-16.671a11.48 11.48 0 0 0-8.138-3.365 11.482 11.482 0 0 0-8.138 3.364 11.442 11.442 0 0 0-3.371 8.123c0 3.173 1.288 6.044 3.37 8.122a11.487 11.487 0 0 0 8.14 3.365c3.178 0 6.054-1.285 8.137-3.365a11.437 11.437 0 0 0 3.372-8.122 11.44 11.44 0 0 0-3.372-8.123Z"
          clipRule="evenodd"
        />
        <path
          fill="#FC9774"
          fillRule="evenodd"
          d="m65.06 68.728-1.987 4.083a1.64 1.64 0 0 1-.416 1.107c-.282.317-.66.5-1.05.543l-3.824 2.459 1.987-4.082a1.648 1.648 0 0 1 1.467-1.652l3.822-2.457Zm-2.999 3.376a.966.966 0 0 0-1.36.081.961.961 0 0 0 .08 1.358.966.966 0 0 0 1.362-.08.96.96 0 0 0-.083-1.36h.001ZM59.938 66.642v-3.724h.732l1.535 2.495v-2.495h.698v3.724h-.753l-1.514-2.449v2.45h-.698ZM59.905 81.523l.735-.074c.044.246.132.424.267.54.135.115.316.171.545.171.241 0 .423-.05.545-.153a.462.462 0 0 0 .185-.36.337.337 0 0 0-.078-.225.613.613 0 0 0-.27-.16 9.16 9.16 0 0 0-.6-.164c-.403-.1-.685-.223-.847-.37a.972.972 0 0 1-.343-.751c0-.19.053-.369.161-.535.108-.165.263-.29.465-.377a1.85 1.85 0 0 1 .732-.131c.466 0 .818.103 1.053.31.236.208.36.482.371.829l-.756.027c-.032-.193-.1-.33-.205-.414-.105-.085-.263-.127-.473-.127-.21 0-.388.046-.51.136a.275.275 0 0 0-.12.232c0 .088.04.164.114.226.095.081.325.165.69.251.366.085.636.175.81.267.175.093.312.22.412.38.099.16.149.357.149.593 0 .212-.06.413-.18.599a1.056 1.056 0 0 1-.503.415c-.217.091-.488.135-.812.135-.471 0-.834-.107-1.087-.325-.252-.217-.403-.534-.453-.949l.003.004ZM51.794 74.685l-.877-3.724h.777l.555 2.558.681-2.558h.898l.651 2.602.568-2.602h.758l-.898 3.724h-.808l-.735-2.784-.74 2.784h-.83Z"
          clipRule="evenodd"
        />
        <path fill="#fff" d="M120.5 57.885H77.267v29.371H120.5V57.885Z" />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M77.267 57.383h43.737v30.88H76.763v-30.88h.504Zm42.729 1.006H77.769v28.868h42.227V58.39Z"
          clipRule="evenodd"
        />
        <path fill="#8BBAE9" d="M120.5 57.885H77.267v3.467H120.5v-3.467Z" />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M77.793 75.28a.71.71 0 1 1-.368-1.375l20.984-5.617 3.971-7.077a.715.715 0 0 1 .97-.273.71.71 0 0 1 .274.968l-4.116 7.34-.148.261-.29.078-21.276 5.696h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M100.739 65.787a.713.713 0 1 1 .523-1.325l19.231 7.594a.712.712 0 1 1-.524 1.323l-19.23-7.593v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M108.79 68.08a.713.713 0 0 1 1.227.724l-6.285 10.564-.153.256-.294.072-14.209 3.47a.712.712 0 0 1-.86-.522.712.712 0 0 1 .526-.858l13.915-3.398 6.133-10.307v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M95.313 80.609a.713.713 0 0 1 1.4.26l-1.225 6.522a.713.713 0 0 1-1.402-.263l1.226-6.52h.001ZM89.048 81.778a.711.711 0 1 1-.279 1.394l-11.186-2.263a.712.712 0 0 1-.559-.836.712.712 0 0 1 .838-.557l11.186 2.262ZM86.817 71.524a.71.71 0 1 1-.732 1.22l-9.027-5.41a.71.71 0 1 1 .731-1.22l9.028 5.41ZM92.893 70.866a.71.71 0 1 1 .943-1.066l5.793 5.126.269.239-.03.352-.383 4.609a.714.714 0 0 1-1.423-.117l.355-4.257-5.523-4.886ZM104.407 77.374a.711.711 0 1 1 1.049-.963l9.713 10.528a.713.713 0 0 1-1.049.964l-9.713-10.528Z"
          clipRule="evenodd"
        />
        <path
          fill="#FC9774"
          fillRule="evenodd"
          d="M91.596 56.277c2.54 2.537 2.386 6.542 0 9.224l-4.62 5.194-4.621-5.194c-2.387-2.68-2.541-6.687 0-9.224 2.54-2.536 6.699-2.536 9.241 0Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M86.975 56.84a3.954 3.954 0 0 1 3.958 3.951 3.953 3.953 0 0 1-3.958 3.95 3.955 3.955 0 0 1-3.958-3.95 3.955 3.955 0 0 1 3.958-3.951Z"
          clipRule="evenodd"
        />
        <path
          fill="#F57A44"
          fillRule="evenodd"
          d="M86.974 57.736c1.69 0 3.06 1.368 3.06 3.055a3.058 3.058 0 0 1-3.06 3.054 3.058 3.058 0 0 1-3.06-3.054 3.058 3.058 0 0 1 3.06-3.055Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M86.383 27.452c-4.68-2.576-5.093-10.009-.166-12.504.605-.306 1.508-.781 2.18-.879.341-.05 2.576.238 2.55.74.084-1.704 1.35-3.155 2.823-4.02 3.7-2.172 8.986-1.03 11.455 2.476 2.469 3.506 1.756 8.857-1.544 11.596 1.312-.587 2.993-.199 3.914.902.922 1.103 1.004 2.823.191 4.007 1.735-1 4.215-.388 5.281 1.308a13.804 13.804 0 0 1 7.933.656c.558.223 1.125.497 1.485.978.36.48.441 1.217.035 1.658-.261.283-.657.39-1.036.465-1.443.287-2.928.295-4.4.302l-20.65.099c-.693.003-1.41.002-2.043-.283-.631-.284-1.154-.936-1.058-1.622-1.006.795-2.192 1.41-3.47 1.55-1.276.138-2.645-.252-3.512-1.196a30.527 30.527 0 0 1-12.36.732c-.678-.1-1.372-.23-1.945-.605-.571-.375-.993-1.057-.866-1.728.126-.673.77-1.156 1.44-1.3.67-.146 1.368-.024 2.04.113-.265-1.307.527-2.661 1.646-3.391 1.118-.73 2.498-.942 3.833-.982a17.768 17.768 0 0 1 6.244.93v-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#F0F3FA"
          fillRule="evenodd"
          d="M72.618 30.782c-.67.146-1.314.627-1.44 1.3-.127.671.295 1.353.866 1.728.572.375 1.267.506 1.944.606 4.112.603 8.349.352 12.36-.733.868.946 2.237 1.334 3.514 1.196 1.276-.139 2.463-.753 3.47-1.55-.097.685.426 1.337 1.058 1.622.631.284 1.349.286 2.042.283l20.65-.099c1.473-.007 2.957-.015 4.4-.302.379-.074.775-.182 1.036-.465.408-.44.325-1.178-.035-1.657a2.153 2.153 0 0 0-.475-.457c-2.094.608-4.402.388-6.578 0-.744-.132-1.538-.31-2.048-.867a1.375 1.375 0 0 1-.219-.332l-.098.02c-1.066-1.695-3.545-2.308-5.281-1.307.813-1.185.731-2.905-.191-4.007-.921-1.102-2.602-1.49-3.914-.903 2.466-2.049 3.487-5.554 2.815-8.658-.316 2.137-1.062 4.22-2.392 5.913-1.571 2-4.025 3.388-6.57 3.318-.343-2.615-2.04-5.014-4.392-6.215 1.275.973 1.309 3.088.217 4.262-1.091 1.173-2.998 1.377-4.442.678-1.443-.699-2.423-2.157-2.802-3.713-.562-2.315.23-4.26 1.441-6.129-.476.19-.964.442-1.338.631-4.927 2.495-4.513 9.927.166 12.504-.501-.17-1.01-.318-1.525-.442-1.696.446-3.576.725-5.25 1.18-1.772.482-3.552 1.572-4.087 3.326a8.007 8.007 0 0 0-.86-.621c-.672-.136-1.37-.259-2.04-.113l-.002.003Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M86.383 27.453c-4.68-2.576-5.093-10.008-.166-12.504.374-.19.86-.443 1.338-.63-2.465 1.194-3.742 4.034-3.785 6.768-.023 1.417.223 2.921 1.15 3.995.836.966 2.132 1.45 3.408 1.527 1.276.078 2.547-.213 3.77-.583-1.446 1.362-3.972 2.386-5.714 1.427h-.001ZM107.785 29.77c.813-1.184.732-2.905-.19-4.007-.921-1.101-2.603-1.49-3.915-.903.97-.178 1.893.733 2.087 1.697.194.964-.207 1.962-.788 2.756-.242.33-.523.644-.881.845-.542.305-1.197.32-1.818.289-1.424-.068-3.035-.467-3.69-1.73-.124.975.544 1.919 1.405 2.394.861.475 1.878.57 2.863.589.929.02 1.872-.022 2.76-.292.89-.27 1.642-.872 2.167-1.637ZM122.483 32.712c.36.48.442 1.217.035 1.658-.261.283-.657.39-1.036.465-1.443.287-2.927.295-4.4.302l-20.65.099c-.693.003-1.41.002-2.042-.283-.632-.284-1.155-.936-1.058-1.622 1.091.766 2.393.917 3.726.966 1.613.059 3.247.058 4.817-.318 1.57-.376 3.088-1.159 4.083-2.428a2.9 2.9 0 0 1-1.296 2.724c4.658-.573 9.375-.035 14.068-.125 1.367-.027 3.248-.169 3.753-1.437Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M93.33 33.331c-1.006.795-2.192 1.41-3.47 1.55-1.276.138-2.645-.252-3.512-1.196a30.525 30.525 0 0 1-12.36.732c-.678-.1-1.372-.23-1.945-.605-.571-.375-.993-1.057-.866-1.728.548 1.058 1.988 1.287 3.178 1.387 1.372.116 2.76.017 4.1-.294a3.085 3.085 0 0 1-1.642-.935c3.667.896 7.624.568 11.093-.92-.147.67.275 1.376.876 1.711.6.335 1.333.354 2.009.225 2.237-.429 4.026-2.548 4.071-4.82.36 1.66-.197 3.842-1.531 4.896v-.003Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M132.2 52.012a1.976 1.976 0 0 1 1.937.243c-.105-1.394.783-2.808 2.086-3.322 1.303-.513 2.918-.085 3.795 1.004.634-2.14 2.704-3.839 4.942-3.83 2.238.01 4.37 1.896 4.454 4.127.608-.8 1.761-.9 2.766-.864 1.002.035 2.07.166 2.836.813 1.085.919 1.19 2.532 1.132 3.951 1.237-.576 2.828-.536 3.847.368 1.019.905 1.149 2.74.076 3.584-.899.706-2.187.527-3.298.255-.94 1.568-2.472 2.812-4.253 3.236-1.781.424-3.789-.038-5.088-1.326-.977 1.377-2.747 2.15-4.425 1.933-1.678-.217-3.19-1.415-3.784-2.997-1.071.737-2.582.773-3.69.089-1.107-.685-1.746-2.053-1.562-3.338-.734.52-1.823.465-2.499-.127-1.18-1.032-.669-3.203.726-3.8h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#F0F3FA"
          fillRule="evenodd"
          d="M136.224 48.934c-1.303.514-2.19 1.927-2.086 3.322a1.978 1.978 0 0 0-1.937-.243c-1.395.594-1.906 2.767-.726 3.8.676.59 1.767.646 2.499.126-.183 1.285.456 2.653 1.562 3.338 1.107.685 2.618.649 3.691-.09.592 1.583 2.105 2.781 3.783 2.998 1.678.218 3.448-.555 4.426-1.933 1.298 1.289 3.306 1.751 5.087 1.326 1.781-.425 3.314-1.668 4.253-3.236 1.11.272 2.399.45 3.298-.255 1.073-.843.943-2.678-.075-3.585-1.02-.905-2.611-.943-3.848-.367.048-1.152-.012-2.43-.616-3.362a8.507 8.507 0 0 1-.71 3.762c-.237.533-.546 1.062-1.033 1.383-.413.27-.913.367-1.401.437-.958.137-1.926.192-2.894.164-.553-.016-1.194-.11-1.473-.587 1.042-1.476 1.183-3.538.349-5.14-.691 1.806-2.321 3.323-4.249 3.52-1.928.198-3.993-1.196-4.207-3.119a3.83 3.83 0 0 0 .631 3.209 4.836 4.836 0 0 1-2.894-.196c-.851-.335-1.639-.972-1.894-1.849-.262-.905.104-1.908.746-2.599.423-.455.925-.726 1.447-.99a3.274 3.274 0 0 0-1.727.167h-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M159.996 54.505c1.019.905 1.149 2.741.076 3.584-.899.706-2.187.527-3.298.255-.94 1.568-2.471 2.812-4.253 3.236-1.781.424-3.789-.038-5.087-1.326-.978 1.377-2.748 2.15-4.426 1.933-1.678-.216-3.19-1.415-3.783-2.997-1.072.737-2.583.773-3.691.089-1.107-.685-1.745-2.053-1.562-3.338-.734.52-1.823.465-2.499-.127.938.027 1.979-.293 2.809-.73a2.042 2.042 0 0 1 .345-1.428c-.148 1.38.277 2.841 1.251 3.831.975.989 2.512 1.437 3.829.995a5.322 5.322 0 0 1-.02-1.93c.563 1.968 2.2 3.64 4.205 4.065 2.005.425 4.276-.529 5.221-2.344a3.755 3.755 0 0 1-.546 2.024c1.062.533 2.351.528 3.463.116 1.115-.412 2.063-1.202 2.792-2.139.648-.831 1.151-1.835 1.125-2.887.546.437.893 1.114.931 1.812.009.148.009.311.104.426a.527.527 0 0 0 .23.138c.82.29 1.78-.125 2.284-.831.505-.707.628-1.566.498-2.425l.002-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M79.634 104.492H49.495a2.077 2.077 0 0 1 2.162-1.588 3.196 3.196 0 0 1 4.562-1.552 4.617 4.617 0 0 1 5.641-3.105 6.422 6.422 0 0 1 5.852-3.766 6.42 6.42 0 0 1 6.28 5.072c.053-.001.104-.004.156-.004a3.878 3.878 0 0 1 3.85 3.384c.807.15 1.449.767 1.636 1.557v.002ZM111.435 100.604h-27.28a1.878 1.878 0 0 1 1.956-1.438 2.893 2.893 0 0 1 4.129-1.404 4.18 4.18 0 0 1 5.106-2.81 5.812 5.812 0 0 1 5.296-3.409 5.812 5.812 0 0 1 5.685 4.591c.048-.001.094-.003.142-.003a3.513 3.513 0 0 1 3.485 3.062c.73.137 1.311.694 1.48 1.411h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M224.127 72.17s4.981-2.619 12.12-3.142a8.375 8.375 0 0 1 8.566 5.716c.069.21.136.428.198.653 1.677 6.02.763 24.243-4.877 28.997-5.64 4.753-16.007 2.748-16.007 2.748V72.168v.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#4567C6"
          fillRule="evenodd"
          d="M208.577 114.642s.603 7.533 1.316 16.588c.965 12.3 4.645 42.95 4.645 42.95s-.78 1.222 3.004.426c0 0 4.638-10.44 5.602-22.449l.044-.594c.897-12.224 2.292-37.965 2.292-37.965l-16.902 1.043-.001.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#3B5BB3"
          fillRule="evenodd"
          d="M208.37 112.039s.81 10.135 1.523 19.191l13.252 20.928.044-.595c.896-12.224 2.291-37.965 2.291-37.965l-17.109-1.559h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#4567C6"
          fillRule="evenodd"
          d="m211.326 110.132 22.776 65.409s2.382-.447 2.915-1.498c0 0 .655-27.661-3.203-34.335-2.179-3.772-3.29-14.342-3.442-17.922-.45-10.635-1.58-13.516-1.58-13.516l-17.466 1.862Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M218.085 179.538h-1.854c-.621-.098-1.081-.277-1.717-.359-.967-.129-1.412.269-1.501.359l-.017.018h-7.878c-.199-.283-.007-.937.179-1.417a1.12 1.12 0 0 1 .736-.674c.836-.242 2.483-.456 3.991-1.818.848-.766 4.096-2.815 4.096-2.815l.017-.004c.071 0 .411.106 1.89 1.35.763.643 2.066-.907 2.066-.907s.244.202.426.578c.146.297.253.705.168 1.207-.118.709.263 2.026.565 2.917.183.541.338.922.338.922s.088.444-1.507.644l.002-.001ZM237.019 179.538h-1.853c-.621-.098-1.08-.277-1.716-.359-.968-.129-1.414.269-1.502.359l-.016.018h-7.878c-.199-.283-.007-.937.179-1.417.124-.328.398-.576.737-.674.834-.242 2.481-.456 3.989-1.818.849-.766 4.097-2.815 4.097-2.815l.016-.004c.072 0 .411.106 1.89 1.35.763.643 2.066-.907 2.066-.907s.245.202.427.578c.146.297.254.705.168 1.207-.117.709.262 2.026.565 2.917.183.541.339.922.339.922s.088.444-1.508.644v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M225.324 71.121s-7.38 3.626-11.646 2.284c0 0 1.048-1.34 2.88-2.345a45.005 45.005 0 0 1-.253-1.692c-.237-1.824-.245-2.864-.245-2.864l4.524-3.64 1.012-.815c-.027.863.025 1.663.14 2.402.009.057.017.115.027.172.736 4.38 3.562 6.497 3.562 6.497l-.001.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#8BBAE9"
          fillRule="evenodd"
          d="M229.536 109.689c.022.47-.948.985-1.368 1.173-1.866.834-3.657 1.52-5.494 2.005a24.27 24.27 0 0 1-3.954.717c-3.952.404-8.623-.483-10.224-.462a.694.694 0 0 1-.448-.17c-.107-.086-.192-4.906-.107-10.981 0-.233 0-.491.021-.725v-.085c.021-2.367.107-4.861.215-7.336.235-5.456.66-10.724 1.388-13.645.855-3.43 4.085-7.73 6.231-8.906 1.817-.997 7.786-2.04 8.085-1.826 3.502 2.613 5.433 10.34 5.399 19.115a58 58 0 0 1-.006.833 75.141 75.141 0 0 1-.1 2.745c-.382 6.474.009 12.087.233 15.35.064.939.115 1.683.13 2.197l-.001.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#F08261"
          fillRule="evenodd"
          d="m221.799 64.556-.038.068c-.284.51-2.234 3.801-5.456 4.745-.237-1.825-.245-2.864-.245-2.864l4.524-3.64a12.93 12.93 0 0 1 1.152 1.586c.042.068.063.107.063.107v-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M214.753 66.404s7.047 1.168 7.709-3.224c.66-4.39 2.016-7.196-2.455-8.127-4.471-.931-5.599.612-6.176 2.024-.578 1.411-.891 8.908.923 9.327h-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M221.171 62.049s.935-.944.396-1.538c-.538-.594-.85.311-1.275.283-.426-.028-1.19-1.273-1.248-2.406-.056-1.131-4.148.596-5.792.058-1.644-.536-3.085-2.732-.515-3.914 1.511-.696 9.062-4.274 11.929-.642 3.653 4.628-1.227 9.479-1.879 10.215-.653.735-1.026.518-1.026.518s-1.15-1.554-.59-2.574Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M224.818 54.316c-.021-.34-.096-1.236-.397-1.783 0 0 .019.924-.112 1.396-.135.471.509.387.509.387Z"
          clipRule="evenodd"
        />
        <path
          fill="#284191"
          fillRule="evenodd"
          d="M225.564 53.56s-.889.096-.945.794l.322.414s-.057-.886.623-1.208ZM229.427 93.355l.22-1.341c-3.266-.53-5.909-2.096-7.855-4.656-1.469-1.932-2.502-4.465-2.837-6.946-.647-4.808.62-7.545 3.876-8.367 2.917-.736 6.287 1.54 6.321 1.561l.771-1.12c-.158-.107-3.907-2.647-7.425-1.759-2.746.693-5.821 2.967-4.89 9.865.214 1.592.9 4.692 3.1 7.585 2.165 2.848 5.098 4.59 8.719 5.177v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M216.575 101.361s-.931-.471-1.44-.7c-.507-.228-1.498-.837-1.574-.404-.075.431-.48 1.266.457 1.419.94.153 2.556-.315 2.556-.315h.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="m211.094 98.064-.644.191a.612.612 0 0 1-.757-.41l-.121-.405a.61.61 0 0 1 .412-.756l.643-.19a.61.61 0 0 1 .757.408l.122.406a.61.61 0 0 1-.412.756Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="m213.244 97.687 2.279 7.662a.984.984 0 0 1-.664 1.222l-2.912.864a.989.989 0 0 1-1.226-.663l-2.278-7.66a.986.986 0 0 1 .664-1.225l2.912-.862a.987.987 0 0 1 1.224.663l.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="m213.337 97.996 2.186 7.351a.985.985 0 0 1-.664 1.223l-2.912.863a.987.987 0 0 1-1.226-.663l-2.141-7.199c.428-.146 1.419-.442 2.129-.393.697.05 2.002-.762 2.627-1.18l.001-.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="m214.972 103.486-4.804 1.425-1.428-4.804 4.802-1.423 1.43 4.802Z"
          clipRule="evenodd"
        />
        <path
          fill="#FFB27D"
          fillRule="evenodd"
          d="M212.272 101.18c1.306-.328 2.483.471 4.303.183 0 0 9.013-6.31 10.592-7.886 1.143-1.14-3.443-6.288-5.833-10.283a.983.983 0 0 0 .362-.128c1.828-1.081 5.498-3.042 8.528-3.353a.987.987 0 0 0 .32-.088c1.941 4.183 3.938 9.593 4.545 15.075a2.124 2.124 0 0 1-.729 1.84c-2.222 1.918-8.315 5.312-15.639 7.417 0 0-1.639 1.101-3.199 1.392-1.569.293-2.218-.577-4.499.732-1.05.603-1.381-.681-1.251-1.348.175-.899 1.04-3.191 2.498-3.553h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#61A0E0"
          fillRule="evenodd"
          d="M226.349 72.283s3.728 3.636 5.487 8.771c0 0-3.494 3.04-10.038 3.648 0 0-2.686-4.931-.722-7.431 1.963-2.5 5.273-4.988 5.273-4.988Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M18.668 70.918c1.136-2.406 4.57-3.364 6.792-1.894 1.283-1.676 3.535-2.555 5.618-2.19 2.082.363 3.9 1.954 4.538 3.965 1.123-.187 2.407.36 2.818 1.42.41 1.06-.385 2.473-1.524 2.464-.373-.004-.752-.143-1.114-.047-.29.078-.518.294-.745.488-2.856 2.443-7.725 1.963-10.046-.988-1.642 1.428-4.364 1.392-5.968-.08.216.198-2.24.71-2.52.665-.897-.14-2.023-.681-2.174-1.678-.314-2.087 2.867-3.12 4.323-2.125h.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#F0F3FA"
          fillRule="evenodd"
          d="M14.344 73.04c.15.998 1.277 1.54 2.174 1.68.279.043 2.736-.468 2.52-.665 1.604 1.471 4.326 1.507 5.968.079 2.322 2.951 7.19 3.43 10.046.989.228-.195.455-.41.746-.488.36-.097.74.043 1.113.046 1.14.01 1.935-1.404 1.524-2.464-.412-1.06-1.694-1.608-2.817-1.42a5.665 5.665 0 0 0-.918-1.741c.107 1.188-.271 2.421-1.06 3.32a3.808 3.808 0 0 1-1.546 1.083c-.862.314-1.812.262-2.724.15-.612-.074-1.232-.179-1.777-.467-.543-.288-1.005-.79-1.098-1.4-.078-.515.113-1.035.364-1.495a5.93 5.93 0 0 1 1.54-1.82c-1.679.284-3.162 1.518-3.743 3.116-.08.226-.153.467-.327.63-.144.137-.34.2-.53.255a9.238 9.238 0 0 1-2.889.338c-.817-.035-1.729-.24-2.165-.93-.29.42-.708.785-1.213.862-.505.078-1.084-.22-1.19-.718-.085-.393.133-.802.447-1.057.112-.091.516-.233.745-.379-1.535-.127-3.435.86-3.189 2.495v.002Z"
          clipRule="evenodd"
        />
        <path
          fill="#E5EEF3"
          fillRule="evenodd"
          d="M25.005 74.134c2.322 2.951 7.19 3.43 10.046.989.227-.195.455-.41.745-.488.361-.097.74.043 1.114.046 1.14.01 1.935-1.404 1.524-2.464-.176.734-.839 1.366-1.533 1.663a2.481 2.481 0 0 1-2.181-.132c-.232.765-.889 1.35-1.626 1.662-.737.312-1.554.383-2.355.393-.555.008-1.115-.013-1.657-.132-.93-.205-1.771-.694-2.578-1.202-.659-.413-1.362-.924-1.505-1.687-.023.401.029.95.006 1.35v.002ZM25.005 74.134c-1.642 1.428-4.364 1.392-5.968-.08.216.198-2.24.709-2.52.665-.897-.14-2.023-.682-2.174-1.678-.246-1.635 1.654-2.622 3.189-2.495-.757.188-1.534.477-1.934 1.145-.4.67-.323 1.654.318 2.1.42.293.977.302 1.485.227.61-.093 1.263-.341 1.546-.89.73.782 1.796 1.189 2.86 1.298 1.064.11 2.148-.083 3.197-.291v-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M142.124 126.949c3.519 0 6.372 2.848 6.372 6.36 0 3.512-2.853 6.36-6.372 6.36-3.518 0-6.372-2.848-6.372-6.36 0-3.512 2.854-6.36 6.372-6.36Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M147.35 137.161a6.362 6.362 0 0 1-5.093 2.541c-3.52 0-6.372-2.848-6.372-6.36 0-2.19 1.11-4.122 2.798-5.266a6.325 6.325 0 0 0-1.277 3.821c0 3.513 2.852 6.36 6.372 6.36a6.345 6.345 0 0 0 3.573-1.095l-.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#4F8ECC"
          fillRule="evenodd"
          d="M142.125 126.677c1.832 0 3.494.743 4.698 1.943a6.607 6.607 0 0 1 1.946 4.688 6.614 6.614 0 0 1-1.946 4.691 6.637 6.637 0 0 1-4.698 1.943 6.636 6.636 0 0 1-4.7-1.943 6.611 6.611 0 0 1-1.946-4.691 6.6 6.6 0 0 1 1.946-4.688 6.63 6.63 0 0 1 4.7-1.944v.001Zm4.31 2.327a6.081 6.081 0 0 0-4.31-1.781 6.082 6.082 0 0 0-4.312 1.784 6.053 6.053 0 0 0-1.785 4.302c0 1.681.683 3.203 1.786 4.304a6.086 6.086 0 0 0 4.312 1.783 6.083 6.083 0 0 0 4.31-1.782 6.065 6.065 0 0 0 1.788-4.305c0-1.68-.683-3.202-1.785-4.302v-.003h-.004Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M29.738 93.512c3.519 0 6.372 2.848 6.372 6.36 0 3.512-2.853 6.36-6.372 6.36-3.518 0-6.372-2.848-6.372-6.36 0-3.512 2.854-6.36 6.372-6.36Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M34.964 103.724a6.366 6.366 0 0 1-5.095 2.54c-3.519 0-6.372-2.848-6.372-6.36 0-2.191 1.11-4.122 2.799-5.267a6.324 6.324 0 0 0-1.278 3.82c0 3.513 2.852 6.36 6.372 6.36a6.341 6.341 0 0 0 3.574-1.094v.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#4F8ECC"
          fillRule="evenodd"
          d="M29.738 93.238c1.834 0 3.495.743 4.697 1.943v.002a6.606 6.606 0 0 1 1.947 4.689 6.638 6.638 0 0 1-6.645 6.632 6.639 6.639 0 0 1-6.646-6.632c0-1.83.744-3.49 1.946-4.69a6.633 6.633 0 0 1 4.7-1.944h.001Zm4.312 2.329a6.082 6.082 0 0 0-4.312-1.782 6.085 6.085 0 0 0-4.312 1.783 6.06 6.06 0 0 0-1.786 4.304c0 1.681.683 3.202 1.786 4.302a6.083 6.083 0 0 0 4.312 1.784 6.089 6.089 0 0 0 4.312-1.781v-.003a6.061 6.061 0 0 0 1.786-4.302c0-1.68-.683-3.204-1.785-4.304l-.001-.001Z"
          clipRule="evenodd"
        />
        <path
          fill="#C3DFFA"
          fillRule="evenodd"
          d="M130.103 6.967c1.606 0 2.908 1.3 2.908 2.902a2.906 2.906 0 0 1-2.908 2.903 2.906 2.906 0 0 1-2.908-2.903 2.906 2.906 0 0 1 2.908-2.902Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="M132.488 11.627a2.906 2.906 0 0 1-2.325 1.159 2.906 2.906 0 0 1-2.908-2.903c0-1 .507-1.88 1.278-2.403a2.905 2.905 0 0 0 2.325 4.647c.604 0 1.166-.183 1.63-.5Z"
          clipRule="evenodd"
        />
        <path
          fill="#4F8ECC"
          fillRule="evenodd"
          d="M130.103 6.842c.837 0 1.596.34 2.144.887a3.017 3.017 0 0 1 0 4.28 3.026 3.026 0 0 1-2.144.887 3.021 3.021 0 0 1-2.144-.887 3.011 3.011 0 0 1-.888-2.14c0-.835.34-1.592.888-2.14a3.024 3.024 0 0 1 2.144-.887Zm1.968 1.063a2.779 2.779 0 0 0-1.968-.814 2.78 2.78 0 0 0-2.784 2.778 2.78 2.78 0 0 0 2.784 2.777 2.778 2.778 0 0 0 1.968-4.741Z"
          clipRule="evenodd"
        />
      </g>
      <defs>
        <clipPath id="a">
          <path fill="#fff" d="M0 0h251v176H0z" />
        </clipPath>
      </defs>
    </svg>
  );
};

export default AddressNotFoundSvg;
